#version 120

varying vec2 vTexCoords;
varying vec3 vPos;
varying vec3 vGlyphPos;

uniform sampler2D diffuse;
uniform vec4 color = vec4(1.0);

uniform bool useGradient;
uniform vec4 gradientStart;
uniform vec4 gradientEnd;
uniform vec2 pos;
uniform vec2 size;
uniform vec2 pageSize;

uniform float sharpness = 0.05;
uniform float gamma = 0.43;


uniform bool clearType;

const vec3 colorScale = vec3(1);
const float pixelShift = 0.2;

float median(float r, float g, float b) {
    return max(min(r, g), min(max(r, g), b));
}

float screenPxRange() {
    vec2 unitRange = vec2(6.0) / vec2(pageSize);
    vec2 screenTexSize = vec2(1.0) / fwidth(vTexCoords);
    return max(0.5 * dot(unitRange, screenTexSize), 1.0);
}

/*
float screenPxRange2() {
    vec2 unitRange = vec2(0.1) / vec2(pageSize);
    vec2 screenTexSize = vec2(1.0) / fwidth(vTexCoords);
    return max(0.5 * dot(unitRange, screenTexSize), 1.0);
}*/

void main() {
    vec4 msd = texture2D(diffuse, vTexCoords);
    
    // Определяем среднее значение для антиалиасинга
    float sd = median(msd.r, msd.g, msd.b);
    float screenPxDistance = screenPxRange() * (sd - 0.6);
    float opacity = clamp(screenPxDistance + 0.5, 0.0, 1.0);
    
    vec4 fillColor = color;
    if (useGradient) {
        fillColor = mix(gradientStart, gradientEnd, (gl_FragCoord.x - pos.x) / (size.x + pos.x - gl_FragCoord.x));
    }
    
    /*if (clearType) {
        float pixel = 1.0 / pageSize.x;
        float adjustedSharpness = sharpness / screenPxRange2(); // Корректировка четкости в зависимости от экрана
        float adjustedGamma = gamma / screenPxRange2(); // Корректировка гаммы в зависимости от экрана


        float alpha_left = texture2D(diffuse, vTexCoords - vec2(pixel * pixelShift, 0.0)).a;
        float alpha_right = texture2D(diffuse, vTexCoords + vec2(pixel * pixelShift, 0.0)).a;

        vec3 clearTypeColor = vec3(
            smoothstep(adjustedGamma + adjustedSharpness, adjustedGamma - adjustedSharpness, alpha_left), 
            smoothstep(adjustedGamma + adjustedSharpness, adjustedGamma - adjustedSharpness, msd.a), 
            smoothstep(adjustedGamma + adjustedSharpness, adjustedGamma - adjustedSharpness, alpha_right)
        );

 

        vec3 ogoColor = 1 - clearTypeColor;
        vec3 preFinal = fillColor.rgb - clearTypeColor ;
        float clearTypeAlpha = (ogoColor.r + ogoColor.g + ogoColor.b) / 3.0;

        gl_FragData[0] = vec4(preFinal, opacity * fillColor.a); 
    } else {*/
        
        gl_FragData[0] = vec4(fillColor.rgb, opacity * fillColor.a); 
        //gl_FragData[0] = msd;
    /*}*/
}
