#version 120

varying vec2 vTexCoords;
varying vec3 vPos;
varying vec3 vGlyphPos;

uniform sampler2D diffuse;
uniform vec4 color = vec4(1);


uniform bool useGradient;
uniform vec4 gradientStart;
uniform vec4 gradientEnd;
uniform vec2 pos;
uniform vec2 size;

// deus гадина ушастая, не пасти код. 
void main() {
    vec4 tex = texture2D(diffuse, vTexCoords);
    
    // Осилил - vk.com/lwjgl2
    if (useGradient) {
        vec4 result = mix(gradientStart, gradientEnd, (gl_FragCoord.x - pos.x) / (gl_FragCoord.x - pos.x + size.x));
        tex *= result;
    } else {
        tex *= color;
    }
    
    gl_FragData[0] = tex;
    gl_FragData[1] = vec4(0, 0, 0, 1);
    gl_FragData[2] = vec4(0, 0, 0, 1);
}