#version 120

varying vec3 vPos;
varying vec4 vColor;
varying vec2 vTexCoords;

uniform sampler2D diffuse;
uniform float weights[512];
uniform int radius;
uniform vec2 screenSize;

uniform float shadowIntensity;
uniform vec2 shadowOffset; 
 

// deus гадина ушастая, не пасти код. 
void main() {	
    vec2 uv = vTexCoords;
    vec4 origColor = texture2D(diffuse, uv);
    vec4 blurColor = vec4(0.0);
    float total = 0;

    int index = 0;
    // Осилил гаусс-блюр - vk.com/lwjgl2
    for (int i = -radius; i <= radius; ++i) {
        for (int j = -radius; j <= radius; ++j) {
            vec2 samplePos = uv + shadowOffset + vec2(float(i*2), float(j*2)) * (1.0 / screenSize);
            float weight = weights[index];
            blurColor += texture2D(diffuse, samplePos) * weight;
            total += weight;
            index++;
        }
    }
    blurColor /= total;

    vec4 shadowColor = texture2D(diffuse, uv + shadowOffset / screenSize);
    shadowColor = mix(vec4(0.0, 0.0, 0.0, 1.0), shadowColor, shadowIntensity);
    
    vec4 color = mix(blurColor * shadowColor, origColor, origColor.a);
    gl_FragData[0] = color;
}

