/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.setting;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import me.zyouime.itemcooldown.category.Categories;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.config.ModConfig;
import me.zyouime.itemcooldown.enums.CooldownRenderType;
import me.zyouime.itemcooldown.setting.Setting;
import me.zyouime.itemcooldown.setting.data.Position;

public class Settings {
    public List<Setting<?>> settingsList = new ArrayList();
    public Setting<List<ItemsCategory>> items = this.register(new Setting<List<ItemsCategory>>("categoriesItems", Types.CATEGORIES, Categories.CATEGORIES));
    public Setting<Number> backgroundAlpha = this.register(new Setting<Float>("backgroundAlpha", Types.NUMBER, Float.valueOf(255.0f)));
    public Setting<String> selectedCategory = this.register(new Setting<String>("selectedCategory", Types.STRING, Categories.HOLYWORLD.getName()));
    public Setting<Boolean> enabled = this.register(new Setting<Boolean>("enabled", Types.BOOLEAN, true));
    public Setting<Boolean> alignment = this.register(new Setting<Boolean>("alignment", Types.BOOLEAN, true));
    public Setting<Number> indent = this.register(new Setting<Float>("indent", Types.NUMBER, Float.valueOf(1.5f)));
    public Setting<CooldownRenderType> cooldownRenderType = this.register(new Setting<CooldownRenderType>("cooldownRenderType", Types.COOLDOWN_RENDER_TYPE, CooldownRenderType.ICONS));
    public Setting<Position> cooldownListPos = this.register(new Setting<Position>("cooldownListPos", Types.POSITION, new Position(100, -150)));

    public void initSettings() {
        JsonObject config = ModConfig.CONFIG_FILE.exists() ? ModConfig.loadConfig(ModConfig.CONFIG_FILE) : new JsonObject();
        for (Setting<?> setting : this.settingsList) {
            String configKey = setting.getConfigKey();
            if (!config.has(configKey)) {
                config.add(configKey, ModConfig.ITEMCOOLDOWN_GSON.toJsonTree(setting.getDefaultValue()));
            }
            JsonElement element = new JsonParser().parse(config.get(configKey).toString());
            setting.initValue(element);
        }
        ModConfig.saveConfig(config, ModConfig.CONFIG_FILE);
    }

    private <T extends Setting<?>> T register(T t) {
        this.settingsList.add(t);
        return t;
    }

    public static class Types {
        public static final Type CATEGORIES = new TypeToken<List<ItemsCategory>>(){}.getType();
        public static final Type NUMBER = new TypeToken<Number>(){}.getType();
        public static final Type STRING = new TypeToken<String>(){}.getType();
        public static final Type BOOLEAN = new TypeToken<Boolean>(){}.getType();
        public static final Type COOLDOWN_RENDER_TYPE = new TypeToken<CooldownRenderType>(){}.getType();
        public static final Type POSITION = new TypeToken<Position>(){}.getType();
    }
}

