/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.setting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import me.zyouime.itemcooldown.config.ModConfig;

public class Setting<T> {
    private T value;
    private final T defaultValue;
    private final String configKey;
    private final Type type;

    public Setting(String configKey, Type type, T defaultValue) {
        this.configKey = configKey;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public void initValue(JsonElement value) {
        this.value = ModConfig.ITEMCOOLDOWN_GSON.fromJson(value, this.type);
    }

    public void save() {
        JsonObject object = ModConfig.loadConfig(ModConfig.CONFIG_FILE);
        object.add(this.configKey, ModConfig.ITEMCOOLDOWN_GSON.toJsonTree(this.value, this.type));
        ModConfig.saveConfig(object, ModConfig.CONFIG_FILE);
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public Type getType() {
        return this.type;
    }

    public void setValue(T value) {
        this.value = value;
    }
}

