/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl.option.entry.impl;

import java.awt.Color;
import java.util.function.Consumer;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.screen.MainScreen;
import me.zyouime.itemcooldown.screen.widget.CustomTooltip;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.screen.widget.impl.IconButton;
import me.zyouime.itemcooldown.screen.widget.impl.option.entry.api.AbstractOptionEntry;
import me.zyouime.itemcooldown.setting.Settings;
import me.zyouime.itemcooldown.util.Textures;
import me.zyouime.itemcooldown.util.Util;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_1268;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class ItemsCategoryOption
extends AbstractOptionEntry<ItemsCategory> {
    public final Consumer<ItemsCategory> callback;
    public ItemsCategory value;
    private final boolean selected;
    private IconButton button;
    private final Settings settings;
    private final MainScreen screen;

    public ItemsCategoryOption(ItemsCategory value, Consumer<ItemsCategory> callback, MainScreen screen) {
        this(value, callback, false, screen);
    }

    public ItemsCategoryOption(ItemsCategory value, Consumer<ItemsCategory> callback, boolean selected, MainScreen screen) {
        this.settings = ItemCooldown.getInstance().settings;
        this.value = value;
        this.callback = callback;
        this.selected = selected;
        this.screen = screen;
    }

    @Override
    public void init() {
        this.button = this.selected ? this.createAddButton() : this.createRemoveButton();
    }

    @Override
    public void render(class_4587 matrixStack, int mouseX, int mouseY, float deltaTick) {
        this.button.active = !this.selected || class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724.method_5998(class_1268.field_5808) != null && !class_310.method_1551().field_1724.method_5998(class_1268.field_5808).method_7960();
        float animProgress = (float)this.anim.getAnimationd();
        Color textColor = ColorHelper.injectAlpha(this.selected ? Color.GREEN : Color.WHITE, 255.0f * animProgress);
        String renderText = Util.substringToWidth(this.value.getName(), this.width / 2.0f - 5.0f);
        RenderHelper.drawAnimatedText(matrixStack, renderText, this.x + 5.0f, this.y + 5.5f, animProgress, 1.0f, textColor);
        this.button.method_25394(matrixStack, mouseX, mouseY, deltaTick);
    }

    @Override
    public void updatePos(float x, float y, float width, float height) {
        super.updatePos(x, y, width, height);
        this.button.updatePos(this.x + this.width - 15.0f, this.y + 2.0f);
    }

    @Override
    public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
        return this.button.getWidgetAtPos(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.button.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void updateAnim() {
        super.updateAnim();
        this.button.updateAnim();
    }

    @Override
    public void apply() {
        this.callback.accept(this.value);
    }

    @Override
    public void resetAnim() {
        super.resetAnim();
        this.button.resetAnim();
    }

    private IconButton createRemoveButton() {
        IconButton button1 = new IconButton(12.0f, 12.0f, button -> {
            this.settings.items.getValue().remove(this.value);
            if (this.value.getName().equals(this.settings.selectedCategory.getValue())) {
                this.settings.selectedCategory.setValue(this.settings.items.getValue().get(0).getName());
                this.screen.recreateList(false, this.screen.itemsList, this.screen::fillItemsToList);
            }
            this.screen.recreateList(true, this.screen.categories, this.screen::fillCategories);
            if (this.screen.categories.getEntriesSize() <= 1) {
                this.screen.categories.setExpanded(false);
            }
        }, Textures.TRASH);
        button1.setTooltip(CustomTooltip.of(button1, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", 70.0f));
        return button1;
    }

    private IconButton createAddButton() {
        IconButton button1 = new IconButton(12.0f, 12.0f, button -> this.screen.openCreateMenu(), Textures.PLUS);
        button1.setTooltip(CustomTooltip.of(button1, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0432 \u044d\u0442\u0443 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e\n\u0427\u0442\u043e\u0431\u044b \u044d\u0442\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c, \u0432\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043c\u0438\u0440\u0435 \u0438 \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0440\u0443\u043a\u0435", 100.0f));
        return button1;
    }

    @Override
    public void setValue(ItemsCategory value) {
        this.value = value;
    }

    @Override
    public ItemsCategory getValue() {
        return this.value;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

