/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl;

import java.awt.Color;
import java.util.function.Consumer;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.widget.impl.ButtonWidget;
import me.zyouime.itemcooldown.setting.Setting;
import me.zyouime.itemcooldown.util.Util;
import me.zyouime.itemcooldown.util.WidgetAnim;
import net.minecraft.class_4587;

public class ToggleWidget
extends ButtonWidget {
    private final Color activeColor;
    private final EaseAnim sizeAnimation = new EaseAnim(10);
    private final Setting<Boolean> setting;
    private final float size;

    public ToggleWidget(float x, float y, float width, float size, Setting<Boolean> setting, Consumer<ButtonWidget> callback, Color color, String optionName) {
        super(x, y, width, size, callback, optionName);
        this.activeColor = color;
        this.setting = setting;
        this.size = size;
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float deltaTick) {
        float sizeProgress = (float)this.sizeAnimation.getAnimationd();
        Color currentColor = this.setting.getValue() != false ? this.activeColor : new Color(196, 196, 196, 196);
        float radius = this.height / 4.0f;
        WidgetAnim anim = WidgetAnim.getAnim(this.x + this.width - this.size, this.y, this.size, this.size, radius, sizeProgress);
        RenderHelper.drawRoundedRect(matrixStack, anim.x, anim.y, anim.width, anim.height, anim.radius, currentColor);
        String renderText = Util.substringToWidth(this.msg, this.width / 1.5f + 2.0f);
        RenderHelper.drawAnimatedText(matrixStack, renderText, this.x, this.y + this.height / 4.0f, sizeProgress, 1.0f, Color.WHITE);
        this.renderDarkening(matrixStack, sizeProgress, radius);
    }

    @Override
    public void renderDarkening(class_4587 matrixStack, float animProgress, float radius) {
        if (!this.active) {
            WidgetAnim anim = WidgetAnim.getAnim(this.getX() + this.width - this.size, this.getY(), this.size, this.size, this.height / 4.0f, animProgress);
            RenderHelper.drawRoundedRect(matrixStack, anim.x, anim.y, anim.width, anim.height, anim.radius, new Color(0, 0, 0, 80));
        }
    }

    @Override
    public void updateAnim(boolean bl) {
        super.updateAnim(bl);
        this.sizeAnimation.update(bl);
    }

    @Override
    public void updateAnim() {
        super.updateAnim();
        this.sizeAnimation.update();
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + this.width - this.size) && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public void resetAnim() {
        this.sizeAnimation.reset();
    }
}

