/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl;

import java.awt.Color;
import java.util.Locale;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.setting.Setting;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class SliderWidget
extends AbstractWidget {
    private float value;
    private final float min;
    private final float max;
    private final Setting<Number> setting;
    private final Color color;
    private final String name;
    private boolean dragging;
    private float sliderPosition;
    private final EaseAnim sliderAnimation = new EaseAnim(10);

    public SliderWidget(float x, float y, float width, float height, float min, float max, Setting<Number> setting, Color color, String name) {
        super(x, y, width, height);
        this.min = min;
        this.max = max;
        this.setting = setting;
        this.value = setting.getValue().floatValue();
        this.color = color;
        this.name = name;
        this.sliderPosition = class_3532.method_15363((float)(x + width * (this.value - min) / (max - min)), (float)x, (float)(x + width));
    }

    @Override
    public void updateAnim(boolean bl) {
        this.sliderAnimation.update(bl);
    }

    @Override
    public void updateAnim() {
        this.sliderAnimation.update();
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float deltaTick) {
        float animProgress = (float)this.sliderAnimation.getAnimationd();
        float centerX = this.x + this.width / 2.0f;
        WidgetAnim sliderAnim = WidgetAnim.getAnim(this.x, this.y, this.width, this.height, this.height / 2.0f, animProgress);
        float animSliderPos = centerX + (this.sliderPosition - centerX) * animProgress;
        RenderHelper.drawRoundedRect(matrixStack, sliderAnim.x, sliderAnim.y, sliderAnim.width, sliderAnim.height, sliderAnim.radius, ColorHelper.injectAlpha(Color.GRAY, 156.0f));
        RenderHelper.drawAnimatedText(matrixStack, this.name, this.x, this.y - (this.height + 3.0f), animProgress, 1.0f, Color.WHITE);
        RenderHelper.drawAnimatedText(matrixStack, Float.toString(this.value), this.x, this.y + (this.height + 2.0f), animProgress, 1.0f, Color.WHITE);
        RenderHelper.drawRoundedRect(matrixStack, sliderAnim.x, sliderAnim.y, animSliderPos - sliderAnim.x, sliderAnim.height, sliderAnim.radius, this.color);
        this.sliderAnimation.update();
        this.renderDarkening(matrixStack, animProgress, this.height / 2.0f);
    }

    private void setValue(double value) {
        double d = this.value;
        this.value = (float)class_3532.method_15350((double)value, (double)this.min, (double)this.max);
        if (d != (double)this.value) {
            float saveValue = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(this.value)));
            this.setting.setValue(Float.valueOf(saveValue));
        }
    }

    @Override
    public void renderTooltip(class_4587 matrixStack, int mouseX, int mouseY) {
        if (this.dragging) {
            return;
        }
        super.renderTooltip(matrixStack, mouseX, mouseY);
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)this.x) / (double)this.width * (double)(this.max - this.min) + (double)this.min);
        this.sliderPosition = (float)Math.max((double)this.x, Math.min(mouseX, (double)(this.x + this.width)));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (!this.active) {
                return true;
            }
            this.dragging = true;
            this.setValueFromMouse(mouseX);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.dragging = false;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setValueFromMouse(mouseX);
            return true;
        }
        return false;
    }

    @Override
    public void resetAnim() {
        this.sliderAnimation.reset();
    }

    public boolean isDragging() {
        return this.dragging;
    }
}

