/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl;

import java.awt.Color;
import java.util.function.Consumer;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.render.font.FontRenderers;
import me.zyouime.itemcooldown.render.font.styled.StyledFontRenderer;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_155;
import net.minecraft.class_4587;

public class SimpleTextFieldWidget
extends AbstractWidget {
    private Consumer<String> callback;
    private String text;
    private int firstCharIndex = 0;
    private final EaseAnim anim = new EaseAnim(10);
    private final EaseAnim textAnim = new EaseAnim(50);
    private Color backgroundColor = new Color(47, 74, 102);
    private Color textColor = Color.WHITE;
    private boolean enabled = false;

    public SimpleTextFieldWidget(float x, float y, float width, float height, String startText) {
        super(x, y, width, height);
        this.text = startText;
    }

    public SimpleTextFieldWidget(float x, float y, float width, float height) {
        this(x, y, width, height, "");
    }

    @Override
    public void updateAnim() {
        this.anim.update();
        if (this.anim.getAnimationd() == 1.0) {
            this.textAnim.update();
        }
    }

    @Override
    public void resetAnim() {
        this.anim.reset();
        this.textAnim.reset();
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        Color arcColor = this.enabled ? Color.WHITE : Color.LIGHT_GRAY;
        float progress = (float)this.anim.getAnimationd();
        String renderText = this.text.substring(this.firstCharIndex);
        WidgetAnim arcAnim = WidgetAnim.getAnim(this.x, this.y, this.width, this.height, 4.0f, progress);
        WidgetAnim backGroundAnim = WidgetAnim.getAnim(this.x + 1.0f, this.y + 1.0f, this.width - 2.0f, this.height - 2.0f, 3.0f, progress);
        RenderHelper.drawArc(matrixStack, arcAnim.x, arcAnim.y, arcAnim.width, arcAnim.height, arcAnim.radius, 1.0f * progress, arcColor);
        RenderHelper.drawRoundedRect(matrixStack, backGroundAnim.x, backGroundAnim.y, backGroundAnim.width, backGroundAnim.height, backGroundAnim.radius, this.backgroundColor);
        float alpha = (float)(255.0 * this.textAnim.getAnimationd());
        Color color = this.enabled ? ColorHelper.injectAlpha(this.textColor, alpha) : ColorHelper.injectAlpha(Color.LIGHT_GRAY, alpha);
        StyledFontRenderer.drawString(matrixStack, FontRenderers.mainFont, renderText, this.x + 3.0f, this.y + this.height * 0.33f, color);
        this.renderDarkening(matrixStack, progress, 4.0f);
    }

    public void resetText() {
        this.setText("");
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.enabled && this.active) {
            switch (keyCode) {
                case 256: {
                    this.enabled = false;
                    return true;
                }
                case 335: {
                    this.enabled = false;
                    return true;
                }
                case 259: {
                    if (!this.text.isEmpty()) {
                        this.text = this.text.substring(0, this.text.length() - 1);
                        this.scroll();
                        this.onChanged();
                    }
                    return true;
                }
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void onChanged() {
        if (this.callback != null) {
            this.callback.accept(this.text);
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.active || !this.enabled) {
            return false;
        }
        if (class_155.method_643((char)chr)) {
            this.text = this.text + chr;
            this.scroll();
            this.onChanged();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (!this.active) {
                return true;
            }
            this.enabled = true;
            return true;
        }
        this.enabled = false;
        return false;
    }

    private void scroll() {
        float maxWidth;
        float textWidth = FontRenderers.mainFont.getWidth(this.text);
        if (textWidth > (maxWidth = this.width - 4.0f)) {
            for (int i = this.firstCharIndex; i < this.text.length(); ++i) {
                String sub = this.text.substring(i);
                if (!(FontRenderers.mainFont.getWidth(sub) <= maxWidth)) continue;
                this.firstCharIndex = i;
                break;
            }
        } else {
            this.firstCharIndex = 0;
        }
    }

    public void setCallback(Consumer<String> callback) {
        this.callback = callback;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

