/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl;

import java.awt.Color;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.Anim;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.screen.widget.api.ListWidget;
import me.zyouime.itemcooldown.screen.widget.impl.option.entry.api.OptionEntry;
import me.zyouime.itemcooldown.util.WidgetAnim;
import net.minecraft.class_4587;

public class OptionsListWidget<T>
extends ListWidget<OptionsListWidgetEntry<T>> {
    private boolean expanded;
    private float animHeight;
    private final EaseAnim anim = new EaseAnim(10);

    public OptionsListWidget(float x, float y, float width, float height, float spacing, float entryHeight) {
        super(x, y, width, height, spacing, entryHeight);
    }

    public void setSelected(OptionEntry<T> option) {
        OptionsListWidgetEntry<T> entry = new OptionsListWidgetEntry<T>(this.getEntryHeight(), option);
        entry.init();
        this.entries.add(0, entry);
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float deltaTick) {
        float animProgress = (float)this.anim.getAnimationd();
        WidgetAnim arcAnim = WidgetAnim.getAnim(this.x, this.y, this.width, this.animHeight, 4.0f, animProgress);
        WidgetAnim roundAnim = WidgetAnim.getAnim(this.x + 1.0f, this.y + 1.0f, this.width - 2.0f, this.animHeight - 2.0f, 3.0f, animProgress);
        RenderHelper.drawArc(matrixStack, arcAnim.x, arcAnim.y, arcAnim.width, arcAnim.height, arcAnim.radius, 1.0f * animProgress, Color.LIGHT_GRAY);
        RenderHelper.drawRoundedRect(matrixStack, roundAnim.x, roundAnim.y, roundAnim.width, roundAnim.height, roundAnim.radius, Color.DARK_GRAY);
        super.method_25394(matrixStack, mouseX, mouseY, deltaTick);
        this.renderDarkening(matrixStack, animProgress, arcAnim.radius);
    }

    @Override
    public void updateAnim() {
        this.anim.update();
        this.animScroll();
        if (this.anim.getAnimationd() == 1.0) {
            for (OptionsListWidgetEntry entry : this.entries) {
                if (!this.isEntryVisible(entry)) continue;
                entry.updateAnim();
            }
        }
        this.updateHeight();
    }

    @Override
    public void renderList(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderHelper.enableScissor((int)this.x, (int)this.y + 2, (int)(this.x + this.width), (int)(this.y + this.animHeight));
        float offset = 0.0f;
        for (int i = 0; i < this.entries.size(); ++i) {
            OptionsListWidgetEntry entry = (OptionsListWidgetEntry)this.entries.get(i);
            if (!this.expanded && i >= 1) break;
            entry.updatePos(this.x, (float)((double)this.y - this.getScrollAmount() + (double)offset), this.width, entry.height);
            if (this.isEntryVisible(entry)) {
                entry.render(matrixStack, mouseX, mouseY, partialTicks);
            } else if (i > 0) {
                entry.resetAnim();
            }
            offset += entry.height + this.spacing;
        }
        RenderHelper.disableScissor();
    }

    @Override
    public float getScrollMax() {
        return this.expanded ? super.getScrollMax() : 0.0f;
    }

    private void updateHeight() {
        float currentHeight = this.expanded ? this.height : ((OptionsListWidgetEntry)this.entries.get((int)0)).height;
        this.animHeight = Anim.fast(this.animHeight, currentHeight, 20.0f);
    }

    @Override
    public boolean isEntryVisible(OptionsListWidgetEntry<T> entry) {
        return entry.y + entry.height >= this.y && entry.y <= this.y + this.animHeight;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.animHeight);
    }

    @Override
    public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
        for (OptionsListWidgetEntry entry : this.entries) {
            AbstractWidget widget = entry.getWidgetAtPos(mouseX, mouseY);
            if (widget == null) continue;
            return widget;
        }
        return super.getWidgetAtPos(mouseX, mouseY);
    }

    @Override
    public float getHeight() {
        return this.animHeight;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.active) {
            for (OptionsListWidgetEntry entry : this.entries) {
                if (!entry.method_25402(mouseX, mouseY, button) || !this.isEntryVisible(entry)) continue;
                if (entry.option.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
                if (this.entries.size() <= 1) {
                    return true;
                }
                this.expanded = !this.expanded;
                OptionsListWidgetEntry selected = (OptionsListWidgetEntry)this.entries.get(0);
                if (!this.expanded) {
                    Object oldValue = selected.getOption().getValue();
                    Object newValue = entry.option.getValue();
                    if (oldValue != null && !oldValue.equals(newValue)) {
                        entry.option.apply();
                    }
                    selected.option.setValue(newValue);
                    this.resetScroll();
                }
                this.entries.forEach(e -> {
                    if (e != selected) {
                        ((OptionsListWidgetEntry)e).option.resetAnim();
                    }
                });
                return true;
            }
        }
        this.collapseAndResetScroll();
        return false;
    }

    public void collapseAndResetScroll() {
        this.expanded = false;
        this.resetScroll();
    }

    @Override
    public void resetAnim() {
        this.anim.reset();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public static class OptionsListWidgetEntry<T>
    extends ListWidget.ListEntry<OptionsListWidgetEntry<T>> {
        private final OptionEntry<T> option;

        public OptionsListWidgetEntry(float height, OptionEntry<T> option) {
            this.height = height;
            this.option = option;
        }

        @Override
        public void init() {
            this.option.init();
        }

        @Override
        public void render(class_4587 matrixStack, int mouseX, int mouseY, float deltaTick) {
            this.option.render(matrixStack, mouseX, mouseY, deltaTick);
        }

        @Override
        public void updateAnim() {
            this.option.updateAnim();
        }

        @Override
        public void resetAnim() {
            this.option.resetAnim();
        }

        @Override
        public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
            return this.option.getWidgetAtPos(mouseX, mouseY);
        }

        @Override
        public void updatePos(float x, float y, float width, float height) {
            super.updatePos(x, y, width, height);
            this.option.updatePos(this.x, this.y, this.width, this.height);
        }

        public OptionEntry<T> getOption() {
            return this.option;
        }
    }
}

