/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.MainScreen;
import me.zyouime.itemcooldown.screen.widget.CustomTooltip;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.screen.widget.api.ListWidget;
import me.zyouime.itemcooldown.screen.widget.impl.IconButton;
import me.zyouime.itemcooldown.util.Textures;
import me.zyouime.itemcooldown.util.Util;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_4587;

public class ItemsListWidget
extends ListWidget<ItemEntry> {
    private final EaseAnim anim = new EaseAnim(100);

    public ItemsListWidget(float x, float y, float width, float height, float spacing, float entryHeight) {
        super(x, y, width, height, spacing, entryHeight);
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        float animProgress = (float)this.anim.getAnimationd();
        RenderHelper.drawArc(matrixStack, this.x, this.y - 4.0f, this.width, this.height + 7.0f, 4.0f, 1.0f * animProgress, ColorHelper.injectAlpha(Color.WHITE, 255.0f * animProgress));
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.renderDarkening(matrixStack, animProgress, 4.0f * animProgress);
    }

    @Override
    public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
        for (ItemEntry entry : this.entries) {
            AbstractWidget widget = entry.getWidgetAtPos(mouseX, mouseY);
            if (widget == null || !this.isEntryVisible(entry)) continue;
            return widget;
        }
        return super.getWidgetAtPos(mouseX, mouseY);
    }

    @Override
    public void updateAnim() {
        super.updateAnim();
        this.anim.update();
    }

    public static class ItemEntry
    extends ListWidget.ListEntry<ItemEntry> {
        private IconButton settingButton;
        private IconButton removeButton;
        private IconButton visibleButton;
        private final AbstractItemCooldown item;
        private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        private final EaseAnim hoveredAnim = new EaseAnim(60);
        private final EaseAnim anim = new EaseAnim(10);
        private final MainScreen screen;

        public ItemEntry(AbstractItemCooldown item, float height, MainScreen screen) {
            this.height = height;
            this.item = item;
            this.screen = screen;
        }

        @Override
        public void init() {
            this.settingButton = new IconButton(button -> this.screen.openEditMenu(this.item), Textures.GEAR);
            this.settingButton.setTooltip(CustomTooltip.of(this.settingButton, "\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 100.0f));
            this.removeButton = new IconButton(button -> {
                ItemsCategory.getCurrentCategory().getItems().remove(this.item);
                this.screen.recreateList(true, this.screen.itemsList, this.screen::fillItemsToList);
            }, Textures.TRASH);
            this.removeButton.setTooltip(CustomTooltip.of(this.removeButton, "\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0443\u0434\u0430\u043b\u0438\u0442\u044c", 100.0f));
            this.visibleButton = new IconButton(button -> this.item.setVisible(!this.item.isVisible()), Textures.EYE);
            this.visibleButton.setTooltip(CustomTooltip.of(this.visibleButton, "\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0441\u043a\u0440\u044b\u0442\u044c/\u0440\u0430\u0441\u043a\u0440\u044b\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u0434\u0430\u0443\u043d\u0430 \u044d\u0442\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430", 100.0f));
            this.addWidget(this.settingButton);
            this.addWidget(this.removeButton);
            this.addWidget(this.visibleButton);
        }

        @Override
        public void render(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.hoveredAnim.setUpdate(this.method_25405(mouseX, mouseY));
            float hovAnimProgress = (float)this.hoveredAnim.getAnimationd();
            Color hovColor = ColorHelper.injectAlpha(Color.WHITE, 60.0f * hovAnimProgress);
            RenderHelper.drawRoundedRect(matrixStack, this.x + 2.0f, this.y, this.width - 4.0f, this.height, 4.0f, hovColor);
            String renderText = Util.substringToWidth(this.item.getCustomName(), this.width / 2.0f - 10.0f);
            float animProgress = (float)this.anim.getAnimationd();
            RenderHelper.drawAnimatedText(matrixStack, renderText, this.x + 24.0f, this.y + 7.5f, animProgress, 1.0f, Color.WHITE);
            RenderHelper.drawAnimatedItem(matrixStack, this.item.getItemStack(), this.x + 4.0f, this.y + 1.0f, animProgress, 1.0f);
            for (AbstractWidget widget : this.widgets) {
                if (widget == this.visibleButton) {
                    this.visibleButton.setTextureColor(this.item.isVisible() ? Color.GREEN : Color.RED);
                }
                widget.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public void resetAnim() {
            this.hoveredAnim.reset();
            this.anim.reset();
            this.widgets.forEach(AbstractWidget::resetAnim);
        }

        @Override
        public void updateAnim() {
            this.hoveredAnim.update();
            this.anim.update();
            this.widgets.forEach(AbstractWidget::updateAnim);
        }

        @Override
        public void updatePos(float x, float y, float width, float height) {
            super.updatePos(x, y, width, height);
            this.settingButton.updatePos(this.x + this.width - 42.0f, this.y + 2.0f);
            this.removeButton.updatePos(this.x + this.width - 20.0f, this.y + 2.0f);
            this.visibleButton.updatePos(this.x + this.width - 64.0f, this.y + 2.0f);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            for (AbstractWidget widget : this.widgets) {
                if (!widget.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        @Override
        public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
            for (AbstractWidget widget : this.widgets) {
                if (widget.getWidgetAtPos(mouseX, mouseY) == null) continue;
                return widget;
            }
            return null;
        }

        public <T extends AbstractWidget> void addWidget(T widget) {
            this.widgets.add(widget);
        }
    }
}

