/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.impl;

import java.awt.Color;
import java.util.function.Consumer;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.util.WidgetAnim;
import net.minecraft.class_4587;

public class ButtonWidget
extends AbstractWidget {
    private final Consumer<ButtonWidget> runnable;
    protected String msg;
    protected Color backgroundColor = new Color(47, 74, 102);
    protected Color arcColor = new Color(164, 199, 235);
    protected Color textColor = Color.WHITE;
    protected final EaseAnim anim = new EaseAnim(10);

    public ButtonWidget(float width, float height, Consumer<ButtonWidget> onPress, String msg) {
        this(0.0f, 0.0f, width, height, onPress, msg);
    }

    public ButtonWidget(float x, float y, float width, float height, Consumer<ButtonWidget> onPress, String msg) {
        super(x, y, width, height);
        this.runnable = onPress;
        this.msg = msg;
    }

    @Override
    public void updateAnim() {
        this.anim.update();
    }

    @Override
    public void updateAnim(boolean bl) {
        this.anim.update(bl);
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float deltaTIck) {
        float progress = (float)this.anim.getAnimationd();
        WidgetAnim arcAnim = WidgetAnim.getAnim(this.x, this.y, this.width, this.height, 4.0f, progress);
        WidgetAnim backAnim = WidgetAnim.getAnim(this.x + 1.0f, this.y + 1.0f, this.width - 2.0f, this.height - 2.0f, 3.0f, progress);
        RenderHelper.drawArc(matrixStack, arcAnim.x, arcAnim.y, arcAnim.width, arcAnim.height, arcAnim.radius, 1.0f * progress, this.arcColor);
        RenderHelper.drawRoundedRect(matrixStack, backAnim.x, backAnim.y, backAnim.width, backAnim.height, backAnim.radius, this.backgroundColor);
        this.renderHeader(matrixStack, progress);
        this.renderDarkening(matrixStack, progress, 4.0f);
    }

    public void renderHeader(class_4587 matrixStack, float animProgress) {
        RenderHelper.drawCenteredAnimatedText(matrixStack, this.msg, this.x + this.width / 2.0f, this.y + 2.0f, (float)this.anim.getAnimationd(), this.textColor);
    }

    public void setArcAndBackgroundColor(Color arc, Color background) {
        this.setArcColor(arc);
        this.setBackgroundColor(background);
    }

    @Override
    public void resetAnim() {
        this.anim.reset();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (!this.active) {
                return true;
            }
            this.runnable.accept(this);
            this.resetAnim();
            return true;
        }
        return false;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setArcColor(Color arcColor) {
        this.arcColor = arcColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }
}

