/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget.api;

import java.util.ArrayList;
import java.util.List;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.Anim;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public abstract class ListWidget<E extends ListEntry<E>>
extends AbstractWidget {
    private double scrollAmount;
    private double targetScrollAmount;
    private final float entryHeight;
    protected final float spacing;
    protected final List<E> entries = new ArrayList();

    public ListWidget(float x, float y, float width, float height, float spacing, float entryHeight) {
        super(x, y, width, height);
        this.spacing = spacing;
        this.entryHeight = entryHeight;
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderList(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void updateAnim() {
        this.animScroll();
        for (ListEntry entry : this.entries) {
            if (!this.isEntryVisible(entry)) continue;
            entry.updateAnim();
        }
    }

    public void addEntry(E entry) {
        this.entries.add(entry);
    }

    public void renderList(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderHelper.enableScissor((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height));
        float offset = 0.0f;
        for (ListEntry entry : this.entries) {
            entry.updatePos(this.x, (float)((double)this.y - this.scrollAmount + (double)offset), this.width, entry.height);
            if (this.isEntryVisible(entry)) {
                entry.render(matrixStack, mouseX, mouseY, partialTicks);
            } else {
                entry.resetAnim();
            }
            offset += entry.height + this.spacing;
        }
        RenderHelper.disableScissor();
    }

    public boolean isEntryVisible(E entry) {
        return ((ListEntry)entry).y + ((ListEntry)entry).height >= this.y && ((ListEntry)entry).y <= this.y + this.height;
    }

    public void clear() {
        this.entries.clear();
    }

    public void animScroll() {
        this.scrollAmount = Anim.fast((float)this.scrollAmount, (float)this.targetScrollAmount, 8.0f);
    }

    public void resetScroll() {
        this.scrollAmount = 0.0;
        this.targetScrollAmount = 0.0;
    }

    public int getEntriesSize() {
        return this.entries.size();
    }

    public float getScrollMax() {
        if (this.entries.isEmpty()) {
            return 0.0f;
        }
        float totalHeight = (float)this.entries.stream().mapToDouble(entry -> entry.height).sum();
        float allSpacing = this.spacing * (float)Math.max(0, this.entries.size() - 1);
        float contentHeight = totalHeight + allSpacing;
        return Math.max(0.0f, contentHeight - this.height);
    }

    public void setScrollAmount(double scrollAmount) {
        int i = scrollAmount == 1.0 ? -1 : 1;
        double d = this.targetScrollAmount + (double)(i * 24);
        this.scroll(d);
    }

    public void scroll(double amount) {
        this.targetScrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getScrollMax());
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.method_25405(mouseX, mouseY)) {
            this.setScrollAmount(amount);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (!this.active) {
                return true;
            }
            for (ListEntry entry : this.entries) {
                if (!entry.method_25402(mouseX, mouseY, button) || !this.isEntryVisible(entry)) continue;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public double getTargetScrollAmount() {
        return this.targetScrollAmount;
    }

    public float getEntryHeight() {
        return this.entryHeight;
    }

    public static abstract class ListEntry<T extends ListEntry<T>>
    implements class_364 {
        public float x;
        public float y;
        public float width;
        public float height;

        public void init() {
        }

        public void render(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        }

        public void updatePos(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.method_25405(mouseX, mouseY);
        }

        public void resetAnim() {
        }

        public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
            return null;
        }

        public void updateAnim() {
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }
    }
}

