/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.widget;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.font.FontRenderers;
import me.zyouime.itemcooldown.render.font.styled.StyledFontRenderer;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import net.minecraft.class_4587;

public class CustomTooltip {
    private final List<String> lines = new ArrayList<String>();
    private final Color backgroundColor;
    private final Color textColor;
    private final Color arcColor;
    private final float width;
    private final AbstractWidget parent;

    private CustomTooltip(List<String> lines, Color backgroundColor, Color arcColor, Color textColor, float width, AbstractWidget parent) {
        this.lines.addAll(lines);
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.width = width;
        this.parent = parent;
        this.arcColor = arcColor;
    }

    public void render(class_4587 matrixStack, double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        float lineHeight = 8.0f;
        float height = (float)this.lines.size() * lineHeight + 2.0f;
        float tooltipX = (float)mouseX + 7.0f;
        float tooltipY = (float)mouseY;
        float mostLongLine = (float)this.lines.stream().mapToDouble(string -> FontRenderers.mainFont.getWidth((String)string) + 7.0f).max().orElse(0.0);
        float renderWidth = Math.min(this.width, mostLongLine);
        RenderHelper.drawArc(matrixStack, tooltipX - 1.0f, tooltipY - 1.0f, renderWidth + 2.0f, height + 2.0f, 4.0f, 1.0f, this.arcColor);
        RenderHelper.drawRoundedRect(matrixStack, tooltipX, tooltipY, renderWidth, height, 3.0f, this.backgroundColor);
        float lineOffset = 0.0f;
        for (String line : this.lines) {
            StyledFontRenderer.drawString(matrixStack, FontRenderers.mainFont, line, tooltipX + 2.0f, tooltipY + 2.5f + lineOffset, this.textColor);
            lineOffset += lineHeight;
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.parent.getX() && mouseX <= (double)(this.parent.getX() + this.parent.getWidth()) && mouseY >= (double)this.parent.getY() && mouseY <= (double)(this.parent.getY() + this.parent.getHeight());
    }

    public static CustomTooltip of(AbstractWidget parent, String tooltip, float width) {
        return new TooltipBuilder(parent, width).tooltip(tooltip).build();
    }

    public static TooltipBuilder builder(AbstractWidget parent, float width) {
        return new TooltipBuilder(parent, width);
    }

    public static class TooltipBuilder {
        private final float width;
        private final AbstractWidget parent;
        private Color backgroundColor = Color.LIGHT_GRAY;
        private Color arcColor = Color.BLACK;
        private Color textColor = Color.BLACK;
        private List<String> lines = new ArrayList<String>();

        public TooltipBuilder(AbstractWidget parent, float width) {
            this.width = width;
            this.parent = parent;
        }

        public TooltipBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public TooltipBuilder arcColor(Color arcColor) {
            this.arcColor = arcColor;
            return this;
        }

        public TooltipBuilder textColor(Color textColor) {
            this.textColor = textColor;
            return this;
        }

        public TooltipBuilder tooltip(String tooltip) {
            String[] split = tooltip.split("\n");
            ArrayList<String> lines = new ArrayList<String>();
            for (String string : split) {
                String[] words = string.split(" ");
                StringBuilder currentLine = new StringBuilder();
                for (String word : words) {
                    float wordW = FontRenderers.mainFont.getWidth(word + " ");
                    float currentW = FontRenderers.mainFont.getWidth(currentLine.toString());
                    if (currentW + wordW < this.width) {
                        currentLine.append(word).append(" ");
                        continue;
                    }
                    lines.add(currentLine.toString().trim());
                    currentLine = new StringBuilder(word).append(" ");
                }
                if (currentLine.length() == 0) continue;
                lines.add(currentLine.toString().trim());
            }
            this.lines = lines;
            return this;
        }

        public CustomTooltip build() {
            return new CustomTooltip(this.lines, this.backgroundColor, this.arcColor, this.textColor, this.width, this.parent);
        }
    }
}

