/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen.menu;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.MainScreen;
import me.zyouime.itemcooldown.screen.widget.CustomTooltip;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.screen.widget.impl.ButtonWidget;
import me.zyouime.itemcooldown.screen.widget.impl.SimpleTextFieldWidget;
import me.zyouime.itemcooldown.util.Util;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_1799;
import net.minecraft.class_4587;

public abstract class BaseItemCooldownMenu
extends AbstractWidget {
    private final List<AbstractWidget> saveAndExitWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> settingsWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> allWidgets = new ArrayList<AbstractWidget>();
    protected final ItemTypes[] itemTypes = new ItemTypes[]{ItemTypes.VANILLA, ItemTypes.CUSTOM};
    protected int i = 0;
    protected ItemTypes itemType = ItemTypes.VANILLA;
    protected boolean resetWhenNoFightMode;
    protected boolean setWhenNoFightMode;
    protected boolean canUseWhenNoFightMode;
    protected boolean resetWhenLeftTheServer = true;
    protected int maxCooldown;
    protected String customName = "";
    protected ButtonWidget itemTypeButton;
    protected ButtonWidget resetWhenNoFightModeButton;
    protected ButtonWidget setWhenNoFightModeButton;
    protected ButtonWidget canUseWhenNoFightModeButton;
    protected ButtonWidget resetWhenLeftTheServerButton;
    protected SimpleTextFieldWidget maxCooldownField;
    protected SimpleTextFieldWidget itemNameField;
    public final float buttonW = 140.0f;
    public final float buttonH = 15.0f;
    public final MainScreen mainScreen;
    public final Color arcColor = Color.WHITE;
    public float tooltipW = 120.0f;
    public float buttonX;
    public float buttonY;
    private final EaseAnim backgroundAnim = new EaseAnim(10);
    private final EaseAnim titleAnim = new EaseAnim(10);

    public BaseItemCooldownMenu(float x, float y, float width, float height, MainScreen screen) {
        super(x, y, width, height);
        this.mainScreen = screen;
    }

    public void init() {
        this.buttonX = this.x + 10.0f;
        this.buttonY = this.y + 35.0f;
        this.initFields();
        this.createOptionWidgets();
        this.createSaveAndExitWidgets();
        this.setWidgetsActive();
        this.allWidgets.addAll(this.saveAndExitWidgets);
        this.allWidgets.addAll(this.settingsWidgets);
    }

    @Override
    public void resetAnim() {
        this.backgroundAnim.reset();
        this.titleAnim.reset();
        for (AbstractWidget widget : this.allWidgets) {
            widget.resetAnim();
        }
    }

    @Override
    public void updateAnim() {
        this.backgroundAnim.update();
        if (this.backgroundAnim.getAnimationd() != 1.0) {
            return;
        }
        this.titleAnim.update();
        for (AbstractWidget widget : this.allWidgets) {
            widget.updateAnim();
        }
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        float radius = 8.0f;
        float animProgress = (float)this.backgroundAnim.getAnimationd();
        WidgetAnim arcAnim = WidgetAnim.getAnim(this.x, this.y, this.width, this.height, radius, animProgress);
        WidgetAnim backAnim = WidgetAnim.getAnim(this.x + 1.0f, this.y + 1.0f, this.width - 2.0f, this.height - 2.0f, radius - 1.0f, animProgress);
        RenderHelper.drawRoundedRect(matrixStack, backAnim.x, backAnim.y, backAnim.width, backAnim.height, backAnim.radius, ColorHelper.BACKGROUND_COLOR);
        RenderHelper.drawArc(matrixStack, arcAnim.x, arcAnim.y, arcAnim.width, arcAnim.height, arcAnim.radius, 1.0f * animProgress, this.arcColor);
        for (AbstractWidget widget : this.allWidgets) {
            widget.method_25394(matrixStack, mouseX, mouseY, delta);
        }
        this.renderMsg(matrixStack);
    }

    @Override
    public void updatePos(float x, float y) {
        super.updatePos(x, y);
        for (AbstractWidget widget : this.settingsWidgets) {
            widget.updatePos(x + 10.0f, widget.y);
        }
        float f = x + 15.0f;
        for (AbstractWidget widget : this.saveAndExitWidgets) {
            widget.updatePos(f, widget.y);
            f += widget.width + 10.0f;
        }
    }

    public abstract class_1799 getItemStack();

    public abstract void initFields();

    public abstract void createSaveAndExitWidgets();

    public void renderMsg(class_4587 matrixStack) {
        matrixStack.method_22903();
        String renderText = Util.substringToWidth(this.customName, this.width - 70.0f);
        float animProgress = (float)this.titleAnim.getAnimationd();
        float renderX = this.x + this.width / 2.0f;
        float renderY = this.y + 6.0f;
        RenderHelper.drawCenteredAnimatedText(matrixStack, renderText, renderX, renderY, animProgress, Color.WHITE);
        matrixStack.method_22903();
        renderY = this.y + 24.0f;
        float scale = 1.1f * (float)this.titleAnim.getAnimationd();
        matrixStack.method_22904((double)renderX, (double)renderY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)(-renderX), (double)(-renderY), 0.0);
        RenderHelper.drawItem(matrixStack, this.getItemStack(), renderX - 8.0f, renderY - 8.0f);
        matrixStack.method_22909();
    }

    private void createOptionWidgets() {
        this.itemTypeButton = new ButtonWidget(this.buttonX, this.buttonY, 140.0f, 15.0f, press -> {
            ++this.i;
            if (this.i >= this.itemTypes.length) {
                this.i = 0;
            }
            this.itemType = this.itemTypes[this.i];
            this.setWidgetsActive();
            press.setMsg(this.setItemType());
        }, this.setItemType());
        this.itemTypeButton.setArcColor(this.arcColor);
        this.itemTypeButton.setBackgroundColor(ColorHelper.BACKGROUND_COLOR);
        this.itemTypeButton.setTextColor(Color.WHITE);
        this.itemTypeButton.setTooltip(CustomTooltip.of(this.itemTypeButton, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430\nVanilla - \u044d\u0442\u043e \u0442\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u043c\u0435\u044e\u0442 \u0432\u0430\u043d\u0438\u043b\u044c\u043d\u044b\u0439 \u043a\u0443\u043b\u0434\u0430\u0443\u043d (\u0441\u0435\u0440\u0435\u043d\u044c\u043a\u043e\u0435 \u0442\u0430\u043a\u043e\u0435 \u043f\u043e\u0432\u0435\u0440\u0445 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0442\u0440\u0430\u043f\u043a\u0430 \u043d\u0430 \u0445\u043e\u043b\u0438\u043a\u0435/\u0444\u0442)\nCustom - \u044d\u0442\u043e \u0442\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u043c\u0435\u044e\u0442 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u043a\u0443\u043b\u0434\u0430\u0443\u043d (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u043a\u0430\u043a \u0438\u0441\u0446\u0435\u043b\u0435\u043d\u0438\u0435 \u043d\u0430 \u0445\u043e\u043b\u0438\u043a\u0435) \u0438 \u0432\u0438\u0437\u0443\u0430\u043b\u044c\u043d\u043e \u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f", this.tooltipW));
        this.itemNameField = new SimpleTextFieldWidget(this.buttonX, this.buttonY + 20.0f, 140.0f, 15.0f, this.customName);
        this.itemNameField.setBackgroundColor(ColorHelper.BACKGROUND_COLOR);
        this.itemNameField.setCallback(string -> {
            this.customName = string;
        });
        this.itemNameField.setTooltip(CustomTooltip.of(this.itemNameField, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0443\u0442 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435, \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043c\u043e\u0434\u0430 \u0438 \u0442.\u0434\n\u041c\u043e\u0436\u0435\u0442\u0435 \u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c - \u043e\u043d\u043e \u0432\u043e\u0437\u044c\u043c\u0435\u0442 \u0434\u0435\u0444\u043e\u043b\u0442 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430", this.tooltipW));
        this.resetWhenNoFightModeButton = this.createOptionButton(40, "ResetWhenNoFightMode", () -> this.resetWhenNoFightMode, newValue -> {
            this.resetWhenNoFightMode = newValue;
        }, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u043f\u043e\u0441\u043b\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u0431\u043e\u044f \u043a\u0434 \u0441\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f\n\u041f\u0440\u0438\u043c\u0435\u0440: \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0437\u0430 5 \u0441\u0435\u043a \u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0440\u0435\u0436\u0438\u043c\u0430 \u0431\u043e\u044f, \u043d\u0430 \u043d\u0435\u0433\u043e \u043d\u0430\u0432\u0435\u0441\u0438\u043b\u043e\u0441\u044c \u043a\u0434 20 \u0441\u0435\u043a,\n\u043d\u043e \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430 \u0431\u043e\u044f \u043a\u0434 \u0441\u0431\u0440\u043e\u0441\u0438\u043b\u0441\u044f, \u0438 \u0432\u043e\u0439\u0434\u044f \u0441\u043d\u043e\u0432\u0430 \u0432 \u043d\u0435\u0433\u043e, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442");
        this.setWhenNoFightModeButton = this.createOptionButton(60, "SetWhenNoFightMode", () -> this.setWhenNoFightMode, newValue -> {
            this.setWhenNoFightMode = newValue;
        }, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u043a\u0434 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u043a\u0430\u0436\u0434\u043e\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0434\u0430\u0436\u0435 \u0435\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0432 \u043f\u0432\u043f");
        this.canUseWhenNoFightModeButton = this.createOptionButton(80, "CanUseWhenNoFightMode", () -> this.canUseWhenNoFightMode, newValue -> {
            this.canUseWhenNoFightMode = newValue;
        }, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430 \u0431\u043e\u044f \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442, \u043d\u043e \u043a\u0434 \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u043d\u0435 \u0443\u0431\u0438\u0440\u0430\u0435\u0442\u0441\u044f, \u0438 \u0432\u043e\u0439\u0434\u044f \u0432 \u0431\u043e\u0439 \u0441\u043d\u043e\u0432\u0430, \u0431\u0443\u0434\u0435\u0442 \u0441\u0440\u0430\u0437\u0443 \u0436\u0435 \u043a\u0434");
        this.resetWhenLeftTheServerButton = this.createOptionButton(100, "ResetWhenLeftTheServer", () -> this.resetWhenLeftTheServer, newValue -> {
            this.resetWhenLeftTheServer = newValue;
        }, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (\u0430\u043d\u043a\u0438) \u043a\u0434 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0441\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f");
        this.maxCooldownField = new SimpleTextFieldWidget(this.buttonX, this.buttonY + 120.0f, 140.0f, 15.0f, String.valueOf(this.maxCooldown));
        this.maxCooldownField.setCallback(this::changedListener);
        this.maxCooldownField.setTooltip(CustomTooltip.of(this.maxCooldownField, "\u041a\u0443\u043b\u0434\u0430\u0443\u043d, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0430\u0432\u0435\u0448\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445\n(\u0422\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432)", this.tooltipW));
        this.maxCooldownField.setBackgroundColor(ColorHelper.BACKGROUND_COLOR);
        this.maxCooldownField.setTextColor(Color.WHITE);
        this.addToSettingsWidget(this.itemNameField);
        this.addToSettingsWidget(this.resetWhenNoFightModeButton);
        this.addToSettingsWidget(this.setWhenNoFightModeButton);
        this.addToSettingsWidget(this.maxCooldownField);
        this.addToSettingsWidget(this.canUseWhenNoFightModeButton);
        this.addToSettingsWidget(this.itemTypeButton);
        this.addToSettingsWidget(this.resetWhenLeftTheServerButton);
    }

    public String getItemName(class_1799 stack) {
        return this.customName.isEmpty() ? stack.method_7964().getString() : this.customName;
    }

    private String setItemType() {
        return "ItemType: " + (Object)((Object)this.itemTypes[this.i]);
    }

    protected ButtonWidget createOptionButton(int yOffset, String optionName, Supplier<Boolean> value, Consumer<Boolean> consumer, String tooltip) {
        ButtonWidget button = new ButtonWidget(this.buttonX, this.buttonY + (float)yOffset, 140.0f, 15.0f, press -> {
            boolean newValue = (Boolean)value.get() == false;
            consumer.accept(newValue);
            press.setMsg(this.getButtonMessage(optionName, newValue));
        }, this.getButtonMessage(optionName, value.get()));
        button.setTooltip(CustomTooltip.of(button, tooltip, 120.0f));
        button.setArcColor(Color.WHITE);
        button.setBackgroundColor(new Color(26, 31, 41));
        return button;
    }

    private String getButtonMessage(String option, boolean value) {
        return option + ": " + (value ? "\u00a7aTrue" : "\u00a7cFalse");
    }

    private void setWidgetsActive() {
        boolean bl;
        this.maxCooldownField.active = bl = this.itemType.equals((Object)this.itemTypes[1]);
        this.setWhenNoFightModeButton.active = bl;
        if (!this.maxCooldownField.active) {
            this.maxCooldownField.setTextColor(Color.GRAY);
        } else {
            this.changedListener(this.maxCooldownField.getText());
        }
    }

    protected void changedListener(String string) {
        try {
            this.maxCooldown = Integer.parseInt(string);
            this.maxCooldownField.setTextColor(Color.WHITE);
        }
        catch (NumberFormatException ignore) {
            this.maxCooldownField.setTextColor(Color.RED);
        }
    }

    public <T extends AbstractWidget> void addToSettingsWidget(T widget) {
        this.settingsWidgets.add(widget);
    }

    public <T extends AbstractWidget> void addToSaveAndExitWidget(T widget) {
        this.saveAndExitWidgets.add(widget);
    }

    @Override
    public AbstractWidget getWidgetAtPos(int mouseX, int mouseY) {
        for (AbstractWidget widget : this.allWidgets) {
            if (widget.getWidgetAtPos(mouseX, mouseY) == null) continue;
            return widget;
        }
        return null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (AbstractWidget widget : this.allWidgets) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        for (AbstractWidget widget : this.allWidgets) {
            if (!widget.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25400(char chr, int modifiers) {
        for (AbstractWidget widget : this.allWidgets) {
            if (!widget.method_25400(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget widget : this.allWidgets) {
            if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static enum ItemTypes {
        VANILLA,
        CUSTOM;

    }
}

