/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.enums.CooldownRenderType;
import me.zyouime.itemcooldown.hud.CooldownItemsList;
import me.zyouime.itemcooldown.hud.CooldownRenderer;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.screen.AbstractScreen;
import me.zyouime.itemcooldown.screen.widget.CustomTooltip;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.screen.widget.impl.OptionsListWidget;
import me.zyouime.itemcooldown.screen.widget.impl.SliderWidget;
import me.zyouime.itemcooldown.screen.widget.impl.ToggleWidget;
import me.zyouime.itemcooldown.screen.widget.impl.option.entry.impl.StringCategoryOption;
import me.zyouime.itemcooldown.setting.Settings;
import me.zyouime.itemcooldown.util.WidgetAnim;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class PositionScreen
extends AbstractScreen {
    public OptionsListWidget<String> renderTypes;
    private AbstractItemCooldown draggedItem;
    private float centerX;
    private float centerY;
    private float offsetX;
    private float offsetY;
    private final Settings settings;
    private CooldownItemsList draggedList;
    private final EaseAnim anim;
    private ToggleWidget alignmentToggle;

    public PositionScreen(class_437 parent) {
        super(parent);
        this.settings = ItemCooldown.getInstance().settings;
        this.anim = new EaseAnim(10);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_1041 window = class_310.method_1551().method_22683();
        this.centerX = (float)window.method_4486() / 2.0f;
        this.centerY = (float)window.method_4502() / 2.0f;
        this.renderTypes = new OptionsListWidget(this.centerX - 70.0f, this.field_22790 - 45, 60.0f, 35.0f, 2.0f, 16.0f);
        this.fillTypes();
        SliderWidget alphaSlider = new SliderWidget(this.centerX + 15.0f, this.field_22790 - 55, 50.0f, 6.0f, 0.0f, 255.0f, this.settings.backgroundAlpha, Color.WHITE, "\u041f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u043e\u0441\u0442\u044c");
        alphaSlider.setTooltip(CustomTooltip.of(alphaSlider, "\u041f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u0434\u043d\u0435\u0433\u043e \u0444\u043e\u043d\u0430 \u0438\u043a\u043e\u043d\u043e\u043a/\u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432", 100.0f));
        SliderWidget indentSlider = new SliderWidget(this.centerX + 15.0f, this.field_22790 - 25, 50.0f, 6.0f, 0.0f, 8.0f, this.settings.indent, Color.WHITE, "\u041e\u0442\u0441\u0442\u0443\u043f\u044b");
        indentSlider.setTooltip(CustomTooltip.of(indentSlider, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435, \u043d\u0430 \u043a\u0430\u043a\u043e\u043c \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \"\u043f\u0440\u0438\u043b\u0438\u043f\u0430\u043d\u0438\u0435\"", 100.0f));
        indentSlider.setActive(this.settings.alignment.getValue());
        this.alignmentToggle = new ToggleWidget(this.centerX - 70.0f, this.field_22790 - 60, 70.0f, 10.0f, this.settings.alignment, press -> {
            this.settings.alignment.setValue(this.settings.alignment.getValue() == false);
            indentSlider.setActive(this.settings.alignment.getValue());
        }, Color.GREEN, "\u041f\u0440\u0438\u043b\u0438\u043f\u0430\u043d\u0438\u0435");
        this.alignmentToggle.setTooltip(CustomTooltip.of(this.alignmentToggle, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u0445\u043e\u0442\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0442\u0430\u0441\u043a\u0438\u0432\u0430\u043d\u0438\u0438 \u0438\u043a\u043e\u043d\u043e\u043a \u043e\u043d\u0438 \u043f\u0440\u0438\u043b\u0438\u043f\u0430\u043b\u0438 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u043e\u0442\u0441\u0442\u0443\u043f\u0435", 100.0f));
        this.alignmentToggle.setActive(this.settings.cooldownRenderType.getValue() == CooldownRenderType.ICONS);
        this.addWidget(alphaSlider);
        this.addWidget(this.renderTypes);
        this.addWidget(this.alignmentToggle);
        this.addWidget(indentSlider);
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        this.method_25420(matrixStack);
        CooldownRenderer.render(matrixStack, false);
        this.anim.update();
        float animProgress = (float)this.anim.getAnimationd();
        float backX = this.centerX - 75.0f;
        float backY = this.field_22790 - 70;
        float backW = 150.0f;
        float backH = 65.0f;
        float radius = 6.0f;
        WidgetAnim arcAnim = WidgetAnim.getAnim(backX, backY, backW, backH, radius, animProgress);
        WidgetAnim backAnim = WidgetAnim.getAnim(backX + 1.0f, backY + 1.0f, backW - 2.0f, backH - 2.0f, radius - 1.0f, animProgress);
        RenderHelper.drawArcAndBackground(matrixStack, arcAnim, backAnim, animProgress, false);
        if (animProgress != 1.0f) {
            return;
        }
        for (AbstractWidget widget : this.widgets) {
            widget.method_25394(matrixStack, mouseX, mouseY, delta);
            widget.updateAnim();
        }
        this.renderTooltips(matrixStack, mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggedItem = null;
        this.draggedList = null;
        for (AbstractWidget widget : this.widgets) {
            if (!widget.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (AbstractWidget widget : this.widgets) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        CooldownRenderType type = this.settings.cooldownRenderType.getValue();
        CooldownItemsList list = CooldownRenderer.cooldownItemsList;
        if (type == CooldownRenderType.ICONS) {
            List<AbstractItemCooldown> items = ItemsCategory.getCurrentCategory().getItems();
            if (items != null && !items.isEmpty()) {
                for (AbstractItemCooldown item : items) {
                    if (!item.isVisible() || !this.checkClick(mouseX, mouseY, item.getX(), item.getY(), 32.0f, 34.0f, () -> {
                        this.draggedItem = item;
                    })) continue;
                    return true;
                }
            }
        } else if (this.checkClick(mouseX, mouseY, list.getX(), list.getY(), list.getAnimWidth(), list.getAnimHeight(), () -> {
            this.draggedList = list;
        })) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean checkClick(double mouseX, double mouseY, float x, float y, float width, float height, Runnable action) {
        float clickX = this.getCenteredX(x, width);
        float clickY = this.getCenteredY(y, height);
        if (mouseX >= (double)clickX && mouseX <= (double)(clickX + width) && mouseY >= (double)clickY && mouseY <= (double)(clickY + height)) {
            this.offsetX = (float)mouseX - clickX;
            this.offsetY = (float)mouseY - clickY;
            action.run();
            return true;
        }
        return false;
    }

    private float getCenteredX(float x, float width) {
        return Math.max(0.0f, Math.min(this.centerX + x, (float)this.field_22789 - width));
    }

    private float getCenteredY(float y, float height) {
        return Math.max(0.0f, Math.min(this.centerY + y, (float)this.field_22790 - height));
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (AbstractWidget widget : this.widgets) {
            if (!widget.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        if (this.draggedList == null && this.draggedItem == null) {
            return false;
        }
        float x = (float)(mouseX - (double)this.centerX - (double)this.offsetX);
        float y = (float)(mouseY - (double)this.centerY - (double)this.offsetY);
        float minX = -this.centerX;
        float minY = -this.centerY;
        float maxX = this.centerX - (this.draggedList != null ? this.draggedList.getAnimWidth() : 32.0f);
        float maxY = this.centerY - (this.draggedList != null ? this.draggedList.getAnimHeight() : 34.0f);
        x = Math.max(minX, Math.min(x, maxX));
        y = Math.max(minY, Math.min(y, maxY));
        if (this.draggedItem != null) {
            List<AbstractItemCooldown> items = ItemsCategory.getCurrentCategory().getItems();
            float indent = this.settings.indent.getValue().floatValue();
            if (this.settings.alignment.getValue().booleanValue()) {
                for (AbstractItemCooldown item : items) {
                    boolean isHorizontal;
                    boolean isVertical;
                    if (item == this.draggedItem || !item.isVisible()) continue;
                    float itemX = item.getX();
                    float itemY = item.getY();
                    boolean bl = isVertical = y + 34.0f > itemY && y < itemY + 34.0f;
                    if (isVertical) {
                        float right = itemX + 32.0f + indent;
                        if (Math.abs(x - right) <= indent) {
                            x = right;
                            y = itemY;
                        }
                        float left = itemX - 32.0f - indent;
                        if (Math.abs(x + 32.0f - itemX) <= indent) {
                            x = left;
                            y = itemY;
                        }
                    }
                    if (!(isHorizontal = x + 32.0f > itemX && x < itemX + 32.0f)) continue;
                    float bottom = itemY + 34.0f + indent;
                    if (Math.abs(y - bottom) <= indent) {
                        y = bottom;
                        x = itemX;
                    }
                    float top = itemY - 34.0f - indent;
                    if (!(Math.abs(y + 34.0f - itemY) <= indent)) continue;
                    y = top;
                    x = itemX;
                }
            }
            this.draggedItem.setX(x);
            this.draggedItem.setY(y);
        } else {
            this.draggedList.setX(x);
            this.draggedList.setY(y);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        for (AbstractWidget widget : this.widgets) {
            if (!widget.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public void method_25419() {
        this.settings.cooldownListPos.getValue().x = CooldownRenderer.cooldownItemsList.getX();
        this.settings.cooldownListPos.getValue().y = CooldownRenderer.cooldownItemsList.getY();
        super.method_25419();
    }

    public void method_25420(class_4587 matrixStack) {
        if (this.field_22787.field_1687 == null) {
            this.method_25434(0);
        }
    }

    private void fillTypes() {
        Consumer<String> callback = string -> {
            this.settings.cooldownRenderType.setValue(CooldownRenderType.valueOf(string));
            CooldownRenderer.resetAllAnim();
            this.alignmentToggle.setActive(this.settings.cooldownRenderType.getValue() == CooldownRenderType.ICONS);
        };
        StringCategoryOption selected = new StringCategoryOption(this.settings.cooldownRenderType.getValue().name(), callback);
        this.renderTypes.setSelected(selected);
        this.renderTypes.setTooltip(CustomTooltip.of(this.renderTypes, "\u0420\u0435\u0436\u0438\u043c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f", 100.0f));
        this.addEntry(CooldownRenderType.ICONS.name(), callback);
        this.addEntry(CooldownRenderType.LIST.name(), callback);
    }

    private void addEntry(String value, Consumer<String> callback) {
        this.renderTypes.addEntry(new OptionsListWidget.OptionsListWidgetEntry<String>(this.renderTypes.getEntryHeight(), new StringCategoryOption(value, callback)));
    }
}

