/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.screen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.hud.CooldownRenderer;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.Anim;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.render.animation.OutCirc;
import me.zyouime.itemcooldown.screen.AbstractScreen;
import me.zyouime.itemcooldown.screen.PositionScreen;
import me.zyouime.itemcooldown.screen.menu.BaseItemCooldownMenu;
import me.zyouime.itemcooldown.screen.menu.CreateItemCooldownMenu;
import me.zyouime.itemcooldown.screen.menu.EditItemCooldownMenu;
import me.zyouime.itemcooldown.screen.widget.CustomTooltip;
import me.zyouime.itemcooldown.screen.widget.api.AbstractWidget;
import me.zyouime.itemcooldown.screen.widget.api.ListWidget;
import me.zyouime.itemcooldown.screen.widget.impl.ButtonWidget;
import me.zyouime.itemcooldown.screen.widget.impl.IconButton;
import me.zyouime.itemcooldown.screen.widget.impl.ItemsListWidget;
import me.zyouime.itemcooldown.screen.widget.impl.OptionsListWidget;
import me.zyouime.itemcooldown.screen.widget.impl.SimpleTextFieldWidget;
import me.zyouime.itemcooldown.screen.widget.impl.ToggleWidget;
import me.zyouime.itemcooldown.screen.widget.impl.TopkaLogo;
import me.zyouime.itemcooldown.screen.widget.impl.option.entry.impl.ItemsCategoryOption;
import me.zyouime.itemcooldown.setting.Settings;
import me.zyouime.itemcooldown.util.Textures;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ButtonHelper;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MainScreen
extends AbstractScreen {
    private final Settings settings;
    public ItemsListWidget itemsList;
    public OptionsListWidget<ItemsCategory> categories;
    private final List<AbstractWidget> createCategoriesWidgets;
    private final EaseAnim anim;
    private final List<ItemsCategory> itemsCategories;
    private float itemListY;
    private float itemListHeight;
    public BaseItemCooldownMenu menu;
    private SimpleTextFieldWidget createCategoryField;
    private final OutCirc menuAnim;
    public boolean isMenuOpen;
    public boolean createCategory;
    private float mainMenuX;
    private float mainMenuY;
    private final Runnable openMenuAction;
    private final float MENU_WIDTH = 160.0f;
    private final float MENU_HEIGHT = 195.0f;

    public MainScreen(class_437 parent) {
        super(parent);
        this.settings = ItemCooldown.getInstance().settings;
        this.createCategoriesWidgets = new ArrayList<AbstractWidget>();
        this.anim = new EaseAnim(10);
        this.itemsCategories = this.settings.items.getValue();
        this.menuAnim = new OutCirc();
        this.isMenuOpen = true;
        this.createCategory = false;
        this.openMenuAction = () -> {
            this.isMenuOpen = true;
            if (this.menu != null) {
                this.menuAnim.reset();
            }
        };
        this.MENU_WIDTH = 160.0f;
        this.MENU_HEIGHT = 195.0f;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_1041 window = class_310.method_1551().method_22683();
        float scaledCenterX = (float)window.method_4486() / 2.0f;
        float scaledCenterY = (float)window.method_4502() / 2.0f;
        this.mainMenuX = scaledCenterX - 110.0f;
        this.mainMenuY = scaledCenterY - 60.0f;
        this.itemListY = this.mainMenuY + 40.0f;
        this.itemListHeight = 180.0f;
        float panelY = this.mainMenuY + 15.0f;
        float itemListX = this.mainMenuX + 10.0f;
        this.itemsList = new ItemsListWidget(itemListX, this.itemListY, 200.0f, 180.0f, 2.0f, 20.0f);
        this.fillItemsToList();
        this.categories = new OptionsListWidget(itemListX, panelY, 100.0f, 35.0f, 2.0f, 16.0f);
        this.fillCategories();
        float itemCooldownMenuX = scaledCenterX - 80.0f;
        this.menuAnim.setValues(itemCooldownMenuX, itemCooldownMenuX - 210.0f);
        IconButton positionButton = new IconButton(this.mainMenuX + 136.0f, panelY, 16.0f, 16.0f, onPress -> {
            this.field_22787.method_1507((class_437)new PositionScreen(this));
            CooldownRenderer.resetAllAnim();
        }, Textures.POSITION_BUTTON);
        positionButton.setTooltip(CustomTooltip.of(positionButton, "\u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435", 60.0f));
        IconButton addCategory = new IconButton(this.mainMenuX + 116.0f, panelY, 16.0f, 16.0f, onPress -> {
            this.categories.active = false;
            this.categories.collapseAndResetScroll();
            this.createCategory = true;
        }, Textures.PLUS);
        addCategory.setTooltip(CustomTooltip.of(addCategory, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", 60.0f));
        TopkaLogo topkaLogo = new TopkaLogo(this.mainMenuX + 188.0f, panelY - 8.0f, 24.0f, 24.0f, onPress -> class_156.method_668().method_670("https://topkaproduct.com/mods/topkacooldown"));
        float createCategoriesWidgetsY = this.mainMenuY + 38.0f;
        this.createCategoryField = new SimpleTextFieldWidget(this.mainMenuX + 10.0f, createCategoriesWidgetsY, 70.0f, 15.0f);
        this.createCategoryField.setBackgroundColor(new Color(26, 31, 41));
        this.createCategoryField.setCallback(this::createCategoryFieldCallback);
        ButtonWidget saveCategory = ButtonHelper.simpleButton(this.mainMenuX + 85.0f, createCategoriesWidgetsY, press -> {
            String categoryName = this.createCategoryField.getText();
            if (this.isHasCategory(categoryName)) {
                return;
            }
            this.settings.selectedCategory.setValue(categoryName);
            this.settings.items.getValue().add(new ItemsCategory(categoryName, new ArrayList<AbstractItemCooldown>()));
            this.recreateList(false, this.categories, this::fillCategories);
            this.recreateList(false, this.itemsList, this::fillItemsToList);
            this.resetCreateCategoriesWidgets();
        }, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        ButtonWidget cancelCategory = ButtonHelper.simpleButton(this.mainMenuX + 150.0f, createCategoriesWidgetsY, press -> this.resetCreateCategoriesWidgets(), "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
        ToggleWidget enabledButton = new ToggleWidget(this.mainMenuX + 160.0f, panelY + 3.0f, 10.0f, 10.0f, this.settings.enabled, press -> {
            this.settings.enabled.setValue(this.settings.enabled.getValue() == false);
            CooldownRenderer.resetAllAnim();
        }, Color.GREEN, "");
        enabledButton.setTooltip(CustomTooltip.of(enabledButton, "\u0412\u043a\u043b/\u0432\u044b\u043a\u043b \u043c\u043e\u0434", 80.0f));
        this.addWidget(enabledButton);
        this.addWidget(topkaLogo);
        this.addWidget(addCategory);
        this.addWidget(positionButton);
        this.addWidget(this.itemsList);
        this.addWidget(this.categories);
        this.addToCategories(this.createCategoryField);
        this.addToCategories(saveCategory);
        this.addToCategories(cancelCategory);
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        this.method_25420(matrixStack);
        float animProgress = (float)this.anim.getAnimationd();
        if (this.menu != null && animProgress == 1.0f) {
            this.renderItemCooldownMenu(matrixStack, mouseX, mouseY, delta);
        }
        float backgroundWidth = 220.0f;
        float backgroundRadius = 8.0f;
        float backgroundHeight = 235.0f;
        WidgetAnim arcAnim = WidgetAnim.getAnim(this.mainMenuX, this.mainMenuY, backgroundWidth, backgroundHeight, backgroundRadius, animProgress);
        WidgetAnim backAnim = WidgetAnim.getAnim(this.mainMenuX + 1.0f, this.mainMenuY + 1.0f, backgroundWidth - 2.0f, backgroundHeight - 2.0f, backgroundRadius - 1.0f, animProgress);
        RenderHelper.drawArcAndBackground(matrixStack, arcAnim, backAnim, animProgress, false);
        float animatedY = Anim.fast(this.itemsList.getY(), this.categories.isExpanded() || this.createCategory ? this.itemListY + 20.0f : this.itemListY, 25.0f);
        float animatedHeight = Anim.fast(this.itemsList.getHeight(), this.categories.isExpanded() || this.createCategory ? this.itemListHeight - 20.0f : this.itemListHeight, 25.0f);
        this.itemsList.setY(animatedY);
        this.itemsList.setHeight(animatedHeight);
        this.renderWidgets(matrixStack, mouseX, mouseY, animProgress);
        this.renderCustomTooltips(matrixStack, mouseX, mouseY);
        this.anim.update();
    }

    private void renderItemCooldownMenu(class_4587 matrixStack, int mouseX, int mouseY, float animProgress) {
        if (!this.isMenuOpen && this.menuAnim.getAnimationD() == this.menuAnim.fromValue) {
            return;
        }
        this.menu.updatePos((float)this.menuAnim.getAnimationD(), this.menu.y);
        this.menu.method_25394(matrixStack, mouseX, mouseY, animProgress);
        this.menu.updateAnim();
        this.menuAnim.update(this.isMenuOpen);
    }

    private void renderWidgets(class_4587 matrixStack, int mouseX, int mouseY, float animProgress) {
        if (animProgress != 1.0f) {
            return;
        }
        for (AbstractWidget widget : this.widgets) {
            if (this.createCategoriesWidgets.contains(widget) && !this.createCategory) continue;
            widget.method_25394(matrixStack, mouseX, mouseY, animProgress);
            widget.updateAnim();
        }
    }

    public void method_25420(class_4587 matrixStack) {
        if (this.field_22787.field_1687 == null) {
            this.method_25434(0);
        }
    }

    public void openCreateMenu() {
        this.openMenuAction.run();
        this.menu = new CreateItemCooldownMenu(0.0f, this.mainMenuY, 160.0f, 195.0f, this);
        this.menu.init();
    }

    public void closeMenu() {
        this.isMenuOpen = false;
    }

    public void resetCreateCategoriesWidgets() {
        this.createCategoriesWidgets.forEach(AbstractWidget::resetAnim);
        this.categories.active = true;
        this.createCategory = false;
        this.createCategoryField.resetText();
    }

    private boolean isHasCategory(String string) {
        return this.settings.items.getValue().stream().anyMatch(category -> category.getName().equalsIgnoreCase(string));
    }

    public void openEditMenu(AbstractItemCooldown itemCooldown) {
        this.openMenuAction.run();
        this.menu = new EditItemCooldownMenu(0.0f, this.mainMenuY, 160.0f, 195.0f, this, itemCooldown);
        this.menu.init();
    }

    public void fillItemsToList() {
        ItemsCategory category = ItemsCategory.getCurrentCategory();
        List<AbstractItemCooldown> items = category.getItems();
        if (items != null && !items.isEmpty()) {
            for (AbstractItemCooldown item : items) {
                ItemsListWidget.ItemEntry entry = new ItemsListWidget.ItemEntry(item, this.itemsList.getEntryHeight(), this);
                entry.init();
                this.itemsList.addEntry(entry);
            }
        }
    }

    private void createCategoryFieldCallback(String string) {
        Color textColor = this.isHasCategory(string) ? Color.RED : Color.WHITE;
        this.createCategoryField.setTextColor(textColor);
    }

    public void fillCategories() {
        Consumer<ItemsCategory> callback = itemCategory -> {
            this.settings.selectedCategory.setValue(itemCategory.getName());
            this.recreateList(false, this.itemsList, this::fillItemsToList);
            this.closeMenu();
            CooldownRenderer.cooldownItemsList.clear();
        };
        float entryHeight = this.categories.getEntryHeight();
        ItemsCategoryOption option = new ItemsCategoryOption(ItemsCategory.getCurrentCategory(), callback, true, this);
        this.categories.setSelected(option);
        if (this.itemsCategories.size() > 1) {
            for (ItemsCategory category1 : this.itemsCategories) {
                OptionsListWidget.OptionsListWidgetEntry<ItemsCategory> entry = new OptionsListWidget.OptionsListWidgetEntry<ItemsCategory>(entryHeight, new ItemsCategoryOption(category1, callback, this));
                entry.init();
                this.categories.addEntry(entry);
            }
        }
    }

    public void recreateList(boolean clearItem, ListWidget<?> list, Runnable recreateAction) {
        list.clear();
        recreateAction.run();
        if (clearItem) {
            list.scroll(list.getScrollAmount() - 24.0);
        } else {
            list.resetScroll();
        }
    }

    private void renderCustomTooltips(class_4587 matrixStack, int mouseX, int mouseY) {
        if (this.isMenuOpen && this.menuAnim.getAnimationD() == this.menuAnim.toValue && this.renderTooltip(this.menu, matrixStack, mouseX, mouseY)) {
            return;
        }
        for (AbstractWidget widget : this.widgets) {
            if (!this.renderTooltip(widget, matrixStack, mouseX, mouseY)) continue;
            return;
        }
    }

    private boolean checkMenu() {
        return this.menu != null && this.isMenuOpen;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.checkMenu() && this.menu.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        for (AbstractWidget widget : this.widgets) {
            if (this.createCategoriesWidgets.contains(widget) && !this.createCategory || !widget.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.checkMenu() && this.menu.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (AbstractWidget widget : this.widgets) {
            if (this.createCategoriesWidgets.contains(widget) && !this.createCategory || !widget.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.checkMenu() && this.menu.method_25400(chr, modifiers)) {
            return true;
        }
        for (AbstractWidget widget : this.widgets) {
            if (this.createCategoriesWidgets.contains(widget) && !this.createCategory || !widget.method_25400(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public <T extends AbstractWidget> void addToCategories(T widget) {
        this.createCategoriesWidgets.add(widget);
        this.widgets.add(widget);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.checkMenu() && this.menu.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        for (AbstractWidget widget : this.widgets) {
            if (this.createCategoriesWidgets.contains(widget) && !this.createCategory || !widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

