/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.render.font.styled;

import java.awt.Color;
import java.util.Locale;
import me.zyouime.itemcooldown.render.font.styled.StyledFont;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4493;
import net.minecraft.class_4587;

public final class StyledFontRenderer {
    public static final String STYLE_CODES = "0123456789abcdefklmnor";
    public static final int[] COLOR_CODES = new int[32];

    public static float drawString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderString(matrices, font, text, x, y, false, color);
    }

    public static float drawCenteredXString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderString(matrices, font, text, x - (double)(font.getWidth(text) / 2.0f), y, false, color);
    }

    public static float drawCenteredYString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderString(matrices, font, text, x, y + (double)(font.getLifting() / 2.0f) + 0.5, false, color);
    }

    public static float drawCenteredXYString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderString(matrices, font, text, x - (double)(font.getWidth(text) / 2.0f), y + (double)(font.getLifting() / 2.0f) + 0.5, false, color);
    }

    public static float drawShadowedString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x, y, color, StyledFontRenderer.getShadowColor(color));
    }

    public static float drawShadowedCenteredXString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x - (double)(font.getWidth(text) / 2.0f), y, color, StyledFontRenderer.getShadowColor(color));
    }

    public static float drawShadowedCenteredYString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x, y + (double)(font.getLifting() / 2.0f) + 0.5, color, StyledFontRenderer.getShadowColor(color));
    }

    public static float drawShadowedCenteredXYString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x - (double)(font.getWidth(text) / 2.0f), y + (double)(font.getLifting() / 2.0f) + 0.5, color, StyledFontRenderer.getShadowColor(color));
    }

    public static float drawShadowedString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color, Color shadowColor) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x, y, color, shadowColor);
    }

    public static float drawShadowedCenteredXString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color, Color shadowColor) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x - (double)(font.getWidth(text) / 2.0f), y, color, shadowColor);
    }

    public static float drawShadowedCenteredYString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color, Color shadowColor) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x, y + (double)(font.getLifting() / 2.0f) + 0.5, color, shadowColor);
    }

    public static float drawShadowedCenteredXYString(class_4587 matrices, StyledFont font, String text, double x, double y, Color color, Color shadowColor) {
        return StyledFontRenderer.renderStringWithShadow(matrices, font, text, x - (double)(font.getWidth(text) / 2.0f), y + (double)(font.getLifting() / 2.0f) + 0.5, color, shadowColor);
    }

    private static float renderStringWithShadow(class_4587 matrices, StyledFont font, String text, double x, double y, Color color, Color shadowColor) {
        StyledFontRenderer.renderString(matrices, font, text, x + 1.0, y, true, shadowColor);
        return StyledFontRenderer.renderString(matrices, font, text, x, y - 1.0, false, color) + 1.0f;
    }

    private static float renderString(class_4587 matrices, StyledFont font, String text, double x, double y, boolean shadow, Color color) {
        float startPos;
        float posX = startPos = (float)x * 2.0f;
        float posY = (float)(y -= (double)font.getLifting()) * 2.0f;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        boolean bold = false;
        boolean italic = false;
        boolean strikethrough = false;
        boolean underline = false;
        class_4493.method_22056();
        class_4493.method_21984((int)770, (int)771);
        matrices.method_22903();
        matrices.method_22905(0.5f, 0.5f, 1.0f);
        class_1159 matrix = matrices.method_23760().method_23761();
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length() && STYLE_CODES.indexOf(text.toLowerCase(Locale.ENGLISH).charAt(i + 1)) != -1) {
                int i1 = STYLE_CODES.indexOf(text.toLowerCase(Locale.ENGLISH).charAt(i + 1));
                if (i1 < 16) {
                    bold = false;
                    strikethrough = false;
                    underline = false;
                    italic = false;
                    if (shadow) {
                        i1 += 16;
                    }
                    int j1 = COLOR_CODES[i1];
                    red = (float)(j1 >> 16 & 0xFF) / 255.0f;
                    green = (float)(j1 >> 8 & 0xFF) / 255.0f;
                    blue = (float)(j1 & 0xFF) / 255.0f;
                    alpha = 1.0f;
                } else if (i1 != 16) {
                    if (i1 == 17) {
                        bold = true;
                    } else if (i1 == 18) {
                        strikethrough = true;
                    } else if (i1 == 19) {
                        underline = true;
                    } else if (i1 == 20) {
                        italic = true;
                    } else if (i1 == 21) {
                        bold = false;
                        strikethrough = false;
                        underline = false;
                        italic = false;
                    }
                }
                ++i;
                continue;
            }
            float f = font.renderGlyph(matrix, c0, posX, posY, bold, italic, red, green, blue, alpha);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            if (strikethrough) {
                float h = font.getLifting() + 2.0f;
                class_4493.method_21912();
                bufferBuilder.method_1328(7, class_290.field_1576);
                bufferBuilder.method_22918(matrix, posX, posY + h + 3.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                bufferBuilder.method_22918(matrix, posX + f, posY + h + 3.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                bufferBuilder.method_22918(matrix, posX + f, posY + h, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                bufferBuilder.method_22918(matrix, posX, posY + h, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                class_289.method_1348().method_1350();
                class_4493.method_21910();
            }
            if (underline) {
                float y1 = posY + font.getLifting() * 2.0f - 4.0f;
                class_4493.method_21912();
                bufferBuilder.method_1328(7, class_290.field_1576);
                bufferBuilder.method_22918(matrix, posX, y1 + 4.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                bufferBuilder.method_22918(matrix, posX + f, y1 + 4.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                bufferBuilder.method_22918(matrix, posX + f, y1 + 2.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                bufferBuilder.method_22918(matrix, posX, y1 + 2.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
                class_289.method_1348().method_1350();
                class_4493.method_21910();
            }
            posX += f;
        }
        matrices.method_22909();
        return (posX - startPos) / 2.0f;
    }

    public static Color getShadowColor(Color color) {
        return new Color((color.getRGB() & 0xFCFCFC) >> 2 | color.getRGB() & 0xFF000000);
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            StyledFontRenderer.COLOR_CODES[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }
}

