/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.render.font.styled;

import java.util.Locale;
import me.zyouime.itemcooldown.render.font.common.AbstractFont;
import me.zyouime.itemcooldown.render.font.common.Lang;
import me.zyouime.itemcooldown.render.font.styled.GlyphPage;
import net.minecraft.class_1159;

public final class StyledFont {
    private final GlyphPage regular;
    private final GlyphPage bold;
    private final GlyphPage italic;
    private final GlyphPage boldItalic;

    public StyledFont(int size, float stretching, float spacing, float lifting, Lang lang) {
        int[] codes = lang.getCharCodes();
        char[] chars = new char[codes[1] - codes[0] + codes[3] - codes[2]];
        int c = 0;
        for (int d = 0; d <= 2; d += 2) {
            for (int i = codes[d]; i <= codes[d + 1] - 1; ++i) {
                chars[c] = (char)i;
                ++c;
            }
        }
        this.regular = new GlyphPage(AbstractFont.getFont(0, size), chars, stretching, spacing, lifting);
        this.bold = new GlyphPage(AbstractFont.getFont(1, size), chars, stretching, spacing, lifting);
        this.italic = new GlyphPage(AbstractFont.getFont(2, size), chars, stretching, spacing, lifting);
        this.boldItalic = new GlyphPage(AbstractFont.getFont(3, size), chars, stretching, spacing, lifting);
    }

    public float renderGlyph(class_1159 matrix, char c, float x, float y, boolean bold, boolean italic, float red, float green, float blue, float alpha) {
        return this.getGlyphPage(bold, italic).renderGlyph(matrix, c, x, y, red, green, blue, alpha);
    }

    public float getWidth(String text) {
        boolean bold = false;
        boolean italic = false;
        float width = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length() && "0123456789abcdefklmnor".indexOf(text.toLowerCase(Locale.ENGLISH).charAt(i + 1)) != -1) {
                int i1 = "0123456789abcdefklmnor".indexOf(text.toLowerCase(Locale.ENGLISH).charAt(i + 1));
                if (i1 < 16) {
                    bold = false;
                    italic = false;
                } else if (i1 == 17) {
                    bold = true;
                } else if (i1 == 20) {
                    italic = true;
                } else if (i1 == 21) {
                    bold = false;
                    italic = false;
                }
                ++i;
                continue;
            }
            width += this.getGlyphPage(bold, italic).getWidth(c0) + this.regular.getSpacing();
        }
        return (width - this.regular.getSpacing()) / 2.0f;
    }

    private GlyphPage getGlyphPage(boolean boldStyle, boolean italicStyle) {
        if (boldStyle && italicStyle) {
            return this.boldItalic;
        }
        if (boldStyle) {
            return this.bold;
        }
        if (italicStyle) {
            return this.italic;
        }
        return this.regular;
    }

    public String getFontName() {
        return this.regular.getFontName();
    }

    public float getFontHeight() {
        return this.regular.getFontHeight();
    }

    public float getStretching() {
        return this.regular.getStretching();
    }

    public float getSpacing() {
        return this.regular.getSpacing();
    }

    public float getLifting() {
        return this.regular.getLifting();
    }
}

