/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.render.font.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.render.font.TextureHelper;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4493;

public abstract class AbstractFont {
    protected final Map<Character, Glyph> glyphs = new HashMap<Character, Glyph>();
    protected int texId;
    protected int imgWidth;
    protected int imgHeight;
    protected float fontHeight;
    protected String fontName;

    public abstract float getStretching();

    public abstract float getSpacing();

    public abstract float getLifting();

    public float getFontHeight() {
        return this.fontHeight;
    }

    public final String getFontName() {
        return this.fontName;
    }

    protected final void setTexture(BufferedImage img) {
        this.texId = TextureHelper.loadTexture(img);
    }

    public final void bindTex() {
        class_4493.method_22081((int)this.texId);
    }

    public final void unbindTex() {
        class_4493.method_22081((int)0);
    }

    public static final Font getFont(int style, int size) {
        Font font = null;
        try {
            font = Font.createFont(0, Objects.requireNonNull(ItemCooldown.class.getClassLoader().getResourceAsStream("assets/itemcooldown/fonts/sf_medium.ttf"))).deriveFont(style, size);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
        return font;
    }

    public final Graphics2D setupGraphics(BufferedImage img, Font font) {
        Graphics2D graphics = img.createGraphics();
        graphics.setFont(font);
        graphics.setColor(new Color(255, 255, 255, 0));
        graphics.fillRect(0, 0, this.imgWidth, this.imgHeight);
        graphics.setColor(Color.WHITE);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return graphics;
    }

    public float renderGlyph(class_1159 matrix, char c, float x, float y, float red, float green, float blue, float alpha) {
        Glyph glyph = this.glyphs.get(Character.valueOf(c));
        if (glyph == null) {
            return 0.0f;
        }
        float pageX = (float)glyph.x / (float)this.imgWidth;
        float pageY = (float)glyph.y / (float)this.imgHeight;
        float pageWidth = (float)glyph.width / (float)this.imgWidth;
        float pageHeight = (float)glyph.height / (float)this.imgHeight;
        float width = (float)glyph.width + this.getStretching();
        float height = glyph.height;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(7, class_290.field_20887);
        bufferBuilder.method_22918(matrix, x, y + height, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX, pageY + pageHeight).method_1344();
        bufferBuilder.method_22918(matrix, x + width, y + height, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX + pageWidth, pageY + pageHeight).method_1344();
        bufferBuilder.method_22918(matrix, x + width, y, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX + pageWidth, pageY).method_1344();
        bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX, pageY).method_1344();
        class_289.method_1348().method_1350();
        return width + this.getSpacing();
    }

    public float getWidth(char ch) {
        Glyph glyph = this.glyphs.get(Character.valueOf(ch));
        if (glyph == null) {
            Glyph fallback = this.glyphs.get(Character.valueOf(' '));
            if (fallback != null) {
                return (float)fallback.width + this.getStretching();
            }
            fallback = this.glyphs.get(Character.valueOf('?'));
            if (fallback != null) {
                return (float)fallback.width + this.getStretching();
            }
            return 0.0f;
        }
        return (float)glyph.width + this.getStretching();
    }

    public float getWidth(String text) {
        float width = 0.0f;
        float sp = this.getSpacing();
        for (int i = 0; i < text.length(); ++i) {
            width += this.getWidth(text.charAt(i)) + sp;
        }
        return (width - sp) / 2.0f;
    }

    public static class Glyph {
        public int x;
        public int y;
        public int width;
        public int height;
    }
}

