/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.render.animation;

import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.render.animation.Anim;
import net.minecraft.class_3532;

public class OutCirc {
    private float prevTick;
    private float tick;
    private float maxTick = 10.0f;
    private boolean where = true;
    public double fromValue = 0.0;
    public double toValue = 1.0;

    public OutCirc(int maxTick) {
        this.maxTick = maxTick;
    }

    public OutCirc(int maxTick, double fromValue, double toValue) {
        this(maxTick);
        this.setValues(fromValue, toValue);
    }

    public OutCirc() {
    }

    public static double createAnimation(double value) {
        value = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        return Math.sqrt(1.0 - Math.pow(value - 1.0, 2.0));
    }

    public void update(boolean where) {
        this.prevTick = this.tick;
        float speed = 1.0f * Anim.deltaTime() * 60.0f;
        this.where = where;
        this.tick = where ? (this.tick += speed) : (this.tick -= speed);
        this.tick = class_3532.method_15363((float)this.tick, (float)0.0f, (float)this.maxTick);
    }

    public void setValues(double fromValue, double toValue) {
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    public double getAnimationD() {
        double t = this.prevTick + (this.tick - this.prevTick) * ItemCooldown.getTickDelta();
        double progress = t / (double)this.maxTick;
        double anim = OutCirc.createAnimation(progress);
        return this.fromValue + (this.toValue - this.fromValue) * anim;
    }

    public void reset() {
        this.prevTick = 0.0f;
        this.tick = 0.0f;
    }

    public void setMaxTick(float maxTick) {
        this.maxTick = maxTick;
    }

    public boolean isWhere() {
        return this.where;
    }
}

