/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.render.animation;

import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.render.animation.Anim;
import net.minecraft.class_3532;

public class OutBack {
    private float prevTick;
    private float tick;
    private float maxTick;
    private boolean update = true;

    public OutBack(int maxTick) {
        this.maxTick = maxTick;
    }

    public OutBack() {
        this(10);
    }

    public double dropAnimation(double value) {
        return 1.0 + 2.70158 * Math.pow(value - 1.0, 3.0) + 1.70158 * Math.pow(value - 1.0, 2.0);
    }

    public void update(boolean update) {
        this.update = update;
        this.update();
    }

    public void update() {
        this.prevTick = this.tick;
        float speed = 1.0f * Anim.deltaTime() * 60.0f;
        this.tick += this.update ? speed : -speed;
        this.tick = class_3532.method_15363((float)this.tick, (float)0.0f, (float)this.maxTick);
    }

    public double getAnimationd() {
        float t = this.prevTick + (this.tick - this.prevTick) * ItemCooldown.getTickDelta();
        return this.dropAnimation(t / this.maxTick);
    }

    public void reset() {
        this.prevTick = 0.0f;
        this.tick = 0.0f;
    }

    public void setMaxTick(float maxTick) {
        this.maxTick = maxTick;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

