/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.render.font.FontRenderers;
import me.zyouime.itemcooldown.render.font.styled.StyledFontRenderer;
import me.zyouime.itemcooldown.render.shader.MyShaders;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class RenderHelper {
    private static final class_289 tessellator = class_289.method_1348();

    public static void drawArcAndBackground(class_4587 matrixStack, WidgetAnim arcAnim, WidgetAnim backAnim, float animProgress, boolean bl) {
        float alpha = bl ? ItemCooldown.getInstance().settings.backgroundAlpha.getValue().floatValue() : 255.0f;
        RenderHelper.drawArc(matrixStack, arcAnim.x, arcAnim.y, arcAnim.width, arcAnim.height, arcAnim.radius, 1.0f * animProgress, ColorHelper.injectAlpha(Color.WHITE, alpha));
        RenderHelper.drawRoundedRect(matrixStack, backAnim.x, backAnim.y, backAnim.width, backAnim.height, backAnim.radius, ColorHelper.injectAlpha(ColorHelper.BACKGROUND_COLOR, alpha));
    }

    public static void drawCenteredAnimatedText(class_4587 matrixStack, String text, float x, float y, float animProgress, Color textColor) {
        RenderHelper.drawCenteredAnimatedText(matrixStack, text, x, y, animProgress, textColor, 1.0f);
    }

    public static void drawCenteredAnimatedText(class_4587 matrixStack, String text, float x, float y, float animProgress, Color textColor, float scale) {
        matrixStack.method_22903();
        float f = scale * animProgress;
        matrixStack.method_22905(f, f, 1.0f);
        StyledFontRenderer.drawCenteredXYString(matrixStack, FontRenderers.mainFont, text, x / f, y / f, textColor);
        matrixStack.method_22909();
    }

    public static void drawAnimatedTextureWithColor(class_4587 matrixStack, class_2960 texture, float x, float y, float textureWidth, float textureHeight, float animProgress, Color color) {
        matrixStack.method_22903();
        float scale = 1.0f * animProgress;
        float centerX = x + textureWidth / 2.0f;
        float centerY = y + textureHeight / 2.0f;
        matrixStack.method_22904((double)centerX, (double)centerY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)(-centerX), (double)(-centerY), 0.0);
        RenderHelper.drawTextureWithColor(matrixStack, x, y, textureWidth, textureHeight, 0.0f, 0.0f, 256.0f, 256.0f, 256.0f, 256.0f, texture, color);
        matrixStack.method_22909();
    }

    public static void drawAnimatedTexture(class_4587 matrixStack, class_2960 texture, float x, float y, float textureWidth, float textureHeight, float animProgress) {
        matrixStack.method_22903();
        float scale = 1.0f * animProgress;
        float centerX = x + textureWidth / 2.0f;
        float centerY = y + textureHeight / 2.0f;
        matrixStack.method_22904((double)centerX, (double)centerY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)(-centerX), (double)(-centerY), 0.0);
        RenderHelper.drawTexture(matrixStack, x, y, textureWidth, textureHeight, 0.0f, 0.0f, 256.0f, 256.0f, 256.0f, 256.0f, texture);
        matrixStack.method_22909();
    }

    public static void drawAnimatedText(class_4587 matrixStack, String text, float x, float y, float animProgress, float scale, Color textColor) {
        matrixStack.method_22903();
        float f = scale * animProgress;
        float centerX = x + FontRenderers.mainFont.getWidth(text) / 2.0f;
        float centerY = y + FontRenderers.mainFont.getFontHeight() / 2.0f;
        matrixStack.method_22904((double)centerX, (double)centerY, 0.0);
        matrixStack.method_22905(f, f, 1.0f);
        matrixStack.method_22904((double)(-centerX), (double)(-centerY), 0.0);
        StyledFontRenderer.drawString(matrixStack, FontRenderers.mainFont, text, x, y, textColor);
        matrixStack.method_22909();
    }

    public static void drawAnimatedItem(class_4587 matrixStack, class_1799 itemStack, float x, float y, float animProgress, float scale) {
        matrixStack.method_22903();
        float f = scale * animProgress;
        float centerX = x + 8.0f;
        float centerY = y + 8.0f;
        matrixStack.method_22904((double)centerX, (double)centerY, 0.0);
        matrixStack.method_22905(f, f, 1.0f);
        matrixStack.method_22904((double)(-centerX), (double)(-centerY), 0.0);
        RenderHelper.drawItem(matrixStack, itemStack, x, y);
        matrixStack.method_22909();
    }

    public static void drawItem(class_4587 matrixStack, class_1799 stack, float x, float y) {
        boolean bl;
        matrixStack.method_22903();
        class_310 client = class_310.method_1551();
        client.method_1531().method_22813(class_1059.field_5275);
        client.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22904((double)x, (double)y, 0.0);
        matrixStack.method_22904(8.0, 8.0, 0.0);
        matrixStack.method_22905(1.0f, -1.0f, 1.0f);
        matrixStack.method_22905(16.0f, 16.0f, 16.0f);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_918 renderer = client.method_1480();
        class_1087 model = renderer.method_4019(stack, null, null);
        boolean bl2 = bl = !model.method_24304();
        if (bl) {
            class_308.method_24210();
        }
        renderer.method_23179(stack, class_809.class_811.field_4317, false, matrixStack, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        if (bl) {
            class_308.method_24211();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        matrixStack.method_22909();
    }

    public static void drawTextureWithColor(class_4587 matrixStack, float x, float y, float width, float height, float u, float v, float regionWidth, float regionHeight, float textureWidth, float textureHeight, class_2960 texture, Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        class_310.method_1551().method_1531().method_22813(texture);
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, class_290.field_20887);
        bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_22915(r, g, b, a).method_22913(u / textureHeight, v / textureHeight).method_1344();
        bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_22915(r, g, b, a).method_22913(u / textureWidth, (v + regionHeight) / textureHeight).method_1344();
        bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22915(r, g, b, a).method_22913((u + regionWidth) / textureWidth, (v + regionHeight) / textureHeight).method_1344();
        bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_22915(r, g, b, a).method_22913((u + regionWidth) / textureWidth, v / textureHeight).method_1344();
        tessellator.method_1350();
    }

    public static void drawTexture(class_4587 matrixStack, float x, float y, float width, float height, float u, float v, float regionWidth, float regionHeight, float textureWidth, float textureHeight, class_2960 texture) {
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        class_310.method_1551().method_1531().method_22813(texture);
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_22913(u / textureHeight, v / textureHeight).method_1344();
        bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_22913(u / textureWidth, (v + regionHeight) / textureHeight).method_1344();
        bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22913((u + regionWidth) / textureWidth, (v + regionHeight) / textureHeight).method_1344();
        bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_22913((u + regionWidth) / textureWidth, v / textureHeight).method_1344();
        tessellator.method_1350();
    }

    public static void drawArc(class_4587 matrixStack, float x, float y, float width, float height, float radius, float arcWidth, Color color) {
        RenderHelper.setupRender();
        RenderHelper.drawArcWithoutSetup(matrixStack, x, y, width, height, radius, arcWidth, color);
        RenderHelper.endRender();
    }

    public static void drawArcWithoutSetup(class_4587 matrixStack, float x, float y, float width, float height, float radius, float arcWidth, Color color) {
        MyShaders.ARC_SHADER.setUniforms(x, y, width, height, radius, arcWidth, color);
        MyShaders.ARC_SHADER.bind();
        RenderHelper.drawShader(matrixStack, x, y, width, height);
        MyShaders.ARC_SHADER.unbind();
    }

    public static void drawShader(class_4587 matrixStack, float x, float y, float width, float height) {
        class_287 vertexConsumer = tessellator.method_1349();
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        vertexConsumer.method_1328(7, class_290.field_1592);
        vertexConsumer.method_22918(matrix4f, x, y, 0.0f).method_1344();
        vertexConsumer.method_22918(matrix4f, x, y + height, 0.0f).method_1344();
        vertexConsumer.method_22918(matrix4f, x + width, y + height, 0.0f).method_1344();
        vertexConsumer.method_22918(matrix4f, x + width, y, 0.0f).method_1344();
        tessellator.method_1350();
    }

    public static void drawCircle(class_4587 matrixStack, float x, float y, float radius, Color color) {
        RenderHelper.setupRender();
        MyShaders.CIRCLE_SHADER.setUniforms(x, y, radius, color);
        MyShaders.CIRCLE_SHADER.bind();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, class_290.field_1592);
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix4f, x - radius, y + radius, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, x + radius, y - radius, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, x - radius, y - radius, 0.0f).method_1344();
        tessellator.method_1350();
        MyShaders.CIRCLE_SHADER.unbind();
        RenderHelper.endRender();
    }

    public static void drawRoundedGradientRect(class_4587 matrixStack, float x, float y, float width, float height, float radius, Color startColor, Color endColor, int dir) {
        RenderHelper.setupRender();
        MyShaders.GRADIENT_RECTANGLE_SHADER.bind();
        MyShaders.GRADIENT_RECTANGLE_SHADER.setUniforms(x, y, width, height, radius, dir, startColor, endColor);
        RenderHelper.drawShader(matrixStack, x, y, width, height);
        RenderHelper.endRender();
    }

    public static void drawRoundedRect(class_4587 matrixStack, float x, float y, float width, float height, float radius, Color color) {
        RenderHelper.setupRender();
        RenderHelper.drawRoundedRectWithoutSetup(matrixStack, x, y, width, height, radius, color);
        RenderHelper.endRender();
    }

    public static void drawRoundedRectWithoutSetup(class_4587 matrixStack, float x, float y, float width, float height, float radius, Color color) {
        MyShaders.RECTANGLE_SHADER.setUniforms(x, y, width, height, radius, color);
        MyShaders.RECTANGLE_SHADER.bind();
        RenderHelper.drawShader(matrixStack, x, y, width, height);
        MyShaders.RECTANGLE_SHADER.unbind();
    }

    public static void enableScissor(int x1, int y1, int x2, int y2) {
        class_1041 window = class_310.method_1551().method_22683();
        int fbHeight = window.method_4506();
        double scale = window.method_4495();
        int ox = (int)Math.floor((double)x1 * scale);
        int oy = (int)Math.floor((double)fbHeight - (double)y2 * scale);
        int w = (int)Math.ceil((double)(x2 - x1) * scale);
        int h = (int)Math.ceil((double)(y2 - y1) * scale);
        RenderSystem.enableScissor((int)ox, (int)oy, (int)w, (int)h);
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static void setupRender() {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
    }

    public static void endRender() {
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
    }
}

