/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.manager;

import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.enums.CooldownRenderType;
import me.zyouime.itemcooldown.hud.CooldownRenderer;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.manager.PvPManager;
import me.zyouime.itemcooldown.screen.MainScreen;
import me.zyouime.itemcooldown.screen.PositionScreen;
import me.zyouime.itemcooldown.setting.Settings;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class EventManager {
    private final PvPManager manager;
    private final Settings settings;

    public EventManager(PvPManager manager) {
        this.settings = ItemCooldown.getInstance().settings;
        this.registerHudRenderEvent();
        this.registerTickEvent();
        this.registerJoinEvent();
        this.registerUseItemEvent();
        this.manager = manager;
    }

    private void registerHudRenderEvent() {
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> {
            if (class_310.method_1551().field_1755 instanceof PositionScreen) {
                return;
            }
            CooldownRenderer.render(matrixStack, true);
        });
    }

    private void registerTickEvent() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (ItemCooldown.getInstance().OPEN_SETTINGS.method_1436()) {
                client.method_1507((class_437)new MainScreen(client.field_1755));
            }
            if (this.settings.cooldownRenderType.getValue() == CooldownRenderType.LIST) {
                CooldownRenderer.cooldownItemsList.tick();
            }
            for (ItemsCategory category : this.settings.items.getValue()) {
                for (AbstractItemCooldown item : category.getItems()) {
                    if (item.getCooldown() >= 0) {
                        item.tick();
                    }
                    if (!item.isResetWhenNoFightMode() || this.manager.isPvp()) continue;
                    item.resetCooldown();
                }
            }
        });
    }

    private void registerJoinEvent() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            ItemsCategory selectedCategory = ItemsCategory.getCurrentCategory();
            for (AbstractItemCooldown item : selectedCategory.getItems()) {
                if (!item.isResetWhenLeftTheServer()) continue;
                item.resetCooldown();
            }
        });
    }

    private void registerUseItemEvent() {
        UseItemCallback.EVENT.register((player, world, hand) -> EventManager.useItem(hand));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> EventManager.useItem(hand).method_5467());
    }

    private static class_1271<class_1799> useItem(class_1268 hand) {
        class_1799 itemStack;
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer != null && !(itemStack = clientPlayer.method_5998(hand).method_7972()).method_7960() && !itemStack.method_19267() && itemStack.method_7909() != class_1802.field_8574) {
            ItemCooldown.getInstance().cooldownManager.useItem();
        }
        return class_1271.method_22430((Object)clientPlayer.method_5998(hand));
    }
}

