/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.manager;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import me.zyouime.itemcooldown.category.Categories;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.hud.CooldownRenderer;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.item.CustomItemCooldown;
import me.zyouime.itemcooldown.item.VanillaItemCooldown;
import me.zyouime.itemcooldown.setting.Settings;
import me.zyouime.itemcooldown.util.SchedulerUtil;
import me.zyouime.itemcooldown.util.Util;
import me.zyouime.itemcooldown.util.inventory.InventoryScreen;
import net.minecraft.class_1268;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2653;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class CooldownManager {
    private final Settings settings;
    public InventoryScreen currentScreen;
    private ScheduledFuture<?> cooldownTask;
    private boolean pendingUse;

    public CooldownManager(Settings settings) {
        this.settings = settings;
    }

    public void setCooldownIfNeeded(class_1799 usedItem, int slot) {
        ItemsCategory selectedCategory;
        if (!this.pendingUse) {
            return;
        }
        List<ItemsCategory> items = this.settings.items.getValue();
        if (!items.contains(selectedCategory = ItemsCategory.getCurrentCategory())) {
            return;
        }
        for (AbstractItemCooldown item : selectedCategory.getItems()) {
            CustomItemCooldown customItemCooldown;
            if (!(item instanceof CustomItemCooldown) || !(customItemCooldown = (CustomItemCooldown)item).shouldSetCooldown(usedItem)) continue;
            CooldownRenderer.cooldownItemsList.addSlot(item);
            if (this.currentScreen != null) {
                this.currentScreen.decrementStack(slot);
            }
            return;
        }
    }

    public void handleSlotUpdate(class_2653 packet) {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            class_746 player = class_310.method_1551().field_1724;
            int slot = packet.method_11450();
            if (player == null) {
                return;
            }
            if (packet.method_11452() != 0) {
                return;
            }
            if (this.currentScreen == null) {
                return;
            }
            class_1799 updatedItem = packet.method_11449();
            class_1799 usedItem = this.currentScreen.getItemStack(slot);
            if (usedItem == null) {
                return;
            }
            if (this.isOver(updatedItem)) {
                this.setCooldownIfNeeded(usedItem, slot);
                return;
            }
            if (!class_1799.method_7987((class_1799)usedItem, (class_1799)updatedItem)) {
                return;
            }
            class_2487 usedItemNbt = Util.getNbtFromItem(usedItem);
            class_2487 updatedItemNbt = Util.getNbtFromItem(updatedItem);
            if (usedItemNbt == null || updatedItemNbt == null) {
                return;
            }
            if (usedItemNbt.equals((Object)updatedItemNbt) && updatedItem.method_7947() < usedItem.method_7947()) {
                this.setCooldownIfNeeded(usedItem, slot);
            }
        });
    }

    public boolean handleHolyWorldBinds() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (this.settings.selectedCategory.getValue().equals(Categories.HOLYWORLD.getName()) && player.method_5998(class_1268.field_5808).method_7909() == class_1802.field_22022) {
            this.useItem();
            return true;
        }
        return false;
    }

    public void useItem() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (this.currentScreen == null) {
            HashMap<Integer, class_1799> screen = new HashMap<Integer, class_1799>();
            List list = player.field_7512.field_7761;
            for (class_1735 slot : list) {
                screen.put(slot.field_7874, slot.method_7677().method_7972());
            }
            this.currentScreen = new InventoryScreen(screen);
        }
        SchedulerUtil.removeTask(this.cooldownTask);
        this.pendingUse = true;
        this.cooldownTask = SchedulerUtil.createTask(this::resetInventoryAndUseAction);
    }

    public void resetAll() {
        SchedulerUtil.removeTask(this.cooldownTask);
        this.resetInventoryAndUseAction();
    }

    public void resetInventoryAndUseAction() {
        this.pendingUse = false;
        this.resetInventoryScreen();
    }

    public void resetInventoryScreen() {
        this.currentScreen = null;
    }

    private boolean isOver(class_1799 updatedItem) {
        return updatedItem.method_7909() == class_1802.field_8162 || updatedItem.method_7909() == class_1802.field_8469;
    }

    public void handleVanillaUpdate(class_1792 item, int cooldown) {
        if (cooldown > 0) {
            ItemsCategory selectedCategory = ItemsCategory.getCurrentCategory();
            selectedCategory.getItems().forEach(ct -> {
                VanillaItemCooldown vic;
                if (ct instanceof VanillaItemCooldown && (vic = (VanillaItemCooldown)ct).getItemStack().method_7909().equals(item) && vic.getCooldown() < cooldown) {
                    vic.setCooldown(cooldown);
                    CooldownRenderer.cooldownItemsList.addSlot(vic);
                }
            });
        }
    }
}

