/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.item;

import com.google.gson.annotations.Expose;
import java.awt.Color;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.enums.CustomItemsNbt;
import me.zyouime.itemcooldown.manager.PvPManager;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.render.font.FontRenderers;
import me.zyouime.itemcooldown.screen.widget.impl.option.entry.api.Animation;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import me.zyouime.itemcooldown.util.helper.NbtHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class AbstractItemCooldown
implements Animation {
    @Expose
    private class_1799 itemStack;
    @Expose
    private int maxCooldown;
    @Expose
    private float x;
    @Expose
    private float y;
    @Expose
    protected boolean resetWhenNoFightMode;
    @Expose
    protected boolean setWhenNoFightMode;
    @Expose
    protected boolean canUseWhenNoFightMode;
    @Expose
    private boolean visible = true;
    @Expose
    private boolean resetWhenLeftTheServer;
    @Expose
    private String customName;
    @Expose
    public class_2487 nbt;
    private int cooldown;
    private final PvPManager pvpManager;
    private EaseAnim anim;
    public static final float ICON_WIDTH = 32.0f;
    public static final float ICON_HEIGHT = 34.0f;

    protected AbstractItemCooldown(AbstractItemBuilder<?, ?> builder) {
        this.pvpManager = ItemCooldown.getInstance().pvpManager;
        this.itemStack = builder.item;
        this.maxCooldown = builder.maxCooldown * 20;
        this.x = builder.x;
        this.y = builder.y;
        this.resetWhenNoFightMode = builder.resetWhenNoFightMode;
        this.setWhenNoFightMode = builder.setWhenNoFightMode;
        this.canUseWhenNoFightMode = builder.canUseWhenNoFightMode;
        this.resetWhenLeftTheServer = builder.resetWhenLeftTheServer;
        this.customName = builder.customName.isEmpty() ? this.itemStack.method_7909().method_7848().getString() : builder.customName;
        this.nbt = NbtHelper.parseNbt(builder.nbt);
    }

    public void render(class_4587 matrixStack, boolean isHud) {
        if (!this.visible) {
            return;
        }
        if (this.anim == null) {
            this.anim = new EaseAnim(7);
        }
        this.updateAnim(isHud);
        float animProgress = (float)this.anim.getAnimationd();
        if (animProgress == 0.0f) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        float sWidth = window.method_4486();
        float sHeight = window.method_4502();
        float centerX = sWidth / 2.0f;
        float centerY = sHeight / 2.0f;
        float maxX = sWidth - 32.0f;
        float maxY = sHeight - 34.0f;
        float renderX = Math.max(0.0f, Math.min(centerX + this.x, maxX));
        float renderY = Math.max(0.0f, Math.min(centerY + this.y, maxY));
        Color timeColor = this.getTimerColor();
        timeColor = ColorHelper.injectAlpha(timeColor, 170.0f);
        WidgetAnim arcAnim = WidgetAnim.getAnim(renderX, renderY, 32.0f, 34.0f, 7.0f, animProgress);
        WidgetAnim backAnim = WidgetAnim.getAnim(renderX + 1.0f, renderY + 1.0f, 30.0f, 32.0f, 6.0f, animProgress);
        RenderHelper.drawArcAndBackground(matrixStack, arcAnim, backAnim, animProgress, true);
        RenderHelper.drawAnimatedItem(matrixStack, this.getItemStack(), renderX + 8.0f, renderY + 4.0f, animProgress, 1.25f);
        float progress = (float)Math.sqrt(this.getPercent() / 100.0f);
        float barX = renderX + 4.0f;
        float barY = renderY + 34.0f - 10.0f;
        float barWidth = 24.0f;
        float barHeight = 7.5f;
        float animatedWidth = barWidth * progress * animProgress;
        WidgetAnim barArcAnim = WidgetAnim.getAnim(barX, barY, barWidth, barHeight, 3.0f, animProgress);
        WidgetAnim progressBackAnim = WidgetAnim.getAnim(barX + 1.0f, barY + 1.0f, animatedWidth - 2.0f, barHeight - 2.0f, 2.0f, animProgress);
        RenderHelper.drawArc(matrixStack, barArcAnim.x, barArcAnim.y, barArcAnim.width, barArcAnim.height, barArcAnim.radius, 1.0f * animProgress, Color.WHITE);
        RenderHelper.drawRoundedRect(matrixStack, progressBackAnim.x, progressBackAnim.y, progressBackAnim.width, progressBackAnim.height, progressBackAnim.radius, timeColor);
        String cd = Integer.toString(this.cooldown / 20);
        RenderHelper.drawCenteredAnimatedText(matrixStack, cd, barX + barWidth / 2.0f, barY + 0.18f, animProgress, Color.WHITE, 0.8f);
    }

    public void tick() {
        --this.cooldown;
    }

    private float getPercent() {
        return (float)this.cooldown / (float)this.maxCooldown * 100.0f;
    }

    public Color getTimerColor() {
        float percent = this.getPercent();
        return percent < 20.0f ? Color.GREEN : (percent < 50.0f ? Color.YELLOW : Color.RED);
    }

    public float getListWidth() {
        return 22.0f + FontRenderers.mainFont.getWidth(this.customName) + 15.0f + FontRenderers.mainFont.getWidth(Integer.toString(this.cooldown / 20));
    }

    public boolean isVisibleAndCooldown() {
        return this.visible && this.cooldown > 0;
    }

    public void setPos(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void resetCooldown() {
        this.setCooldown(0);
    }

    @Override
    public void updateAnim(boolean bl) {
        this.anim.update(!bl || this.cooldown > 0);
    }

    @Override
    public void updateAnim() {
    }

    @Override
    public void resetAnim() {
        if (this.anim != null) {
            this.anim.reset();
        }
    }

    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean isResetWhenNoFightMode() {
        return this.resetWhenNoFightMode;
    }

    public boolean isSetWhenNoFightMode() {
        return this.setWhenNoFightMode;
    }

    public boolean isCanUseWhenNoFightMode() {
        return this.canUseWhenNoFightMode;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isResetWhenLeftTheServer() {
        return this.resetWhenLeftTheServer;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public PvPManager getPvpManager() {
        return this.pvpManager;
    }

    public EaseAnim getAnim() {
        return this.anim;
    }

    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    public void setMaxCooldown(int maxCooldown) {
        this.maxCooldown = maxCooldown;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setResetWhenNoFightMode(boolean resetWhenNoFightMode) {
        this.resetWhenNoFightMode = resetWhenNoFightMode;
    }

    public void setSetWhenNoFightMode(boolean setWhenNoFightMode) {
        this.setWhenNoFightMode = setWhenNoFightMode;
    }

    public void setCanUseWhenNoFightMode(boolean canUseWhenNoFightMode) {
        this.canUseWhenNoFightMode = canUseWhenNoFightMode;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setResetWhenLeftTheServer(boolean resetWhenLeftTheServer) {
        this.resetWhenLeftTheServer = resetWhenLeftTheServer;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void setNbt(class_2487 nbt) {
        this.nbt = nbt;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void setAnim(EaseAnim anim) {
        this.anim = anim;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public String getCustomName() {
        return this.customName;
    }

    public static abstract class AbstractItemBuilder<T extends AbstractItemBuilder<T, E>, E extends AbstractItemCooldown>
    implements Builder<T, E> {
        protected final class_1799 item;
        protected int maxCooldown;
        protected float x;
        protected float y;
        protected String customName = "";
        protected String nbt = "{}";
        protected boolean resetWhenNoFightMode = false;
        protected boolean setWhenNoFightMode = true;
        protected boolean canUseWhenNoFightMode = false;
        protected boolean resetWhenLeftTheServer = true;

        public AbstractItemBuilder(class_1799 item) {
            this.item = item;
        }

        @Override
        public T getThis() {
            return (T)this;
        }

        public T setMaxCooldown(int maxCooldown) {
            this.maxCooldown = maxCooldown;
            return this.getThis();
        }

        public T setPos(float x, float y) {
            this.x = x;
            this.y = y;
            return this.getThis();
        }

        public T setX(float x) {
            this.x = x;
            return this.getThis();
        }

        public T setNbt(CustomItemsNbt nbt) {
            this.nbt = nbt.nbt;
            return this.getThis();
        }

        public T setNbt(String nbt) {
            this.nbt = nbt;
            return this.getThis();
        }

        public T setY(float y) {
            this.y = y;
            return this.getThis();
        }

        public T setCustomName(String customName) {
            this.customName = customName;
            return this.getThis();
        }

        public T resetWhenLeftTheServer(boolean resetWhenLeftTheServer) {
            this.resetWhenLeftTheServer = resetWhenLeftTheServer;
            return this.getThis();
        }

        public T resetWhenNoFightMode(boolean resetWhenNoFightMode) {
            this.resetWhenNoFightMode = resetWhenNoFightMode;
            return this.getThis();
        }

        public T setWhenNoFightMode(boolean setWhenNoFightMode) {
            this.setWhenNoFightMode = setWhenNoFightMode;
            return this.getThis();
        }

        public T canUseWhenNoFightMode(boolean canUseWhenNoFightMode) {
            this.canUseWhenNoFightMode = canUseWhenNoFightMode;
            return this.getThis();
        }
    }

    private static interface Builder<T extends AbstractItemBuilder<T, E>, E extends AbstractItemCooldown> {
        public T getThis();

        public E build();
    }
}

