/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.hud;

import java.util.List;
import me.zyouime.itemcooldown.category.ItemsCategory;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.enums.CooldownRenderType;
import me.zyouime.itemcooldown.hud.CooldownItemsList;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.setting.Settings;
import net.minecraft.class_4587;

public class CooldownRenderer {
    private static final Settings settings = ItemCooldown.getInstance().settings;
    public static CooldownItemsList cooldownItemsList;

    public static void initCooldownsList() {
        cooldownItemsList = new CooldownItemsList(settings);
    }

    public static void render(class_4587 matrixStack, boolean isHud) {
        if (!CooldownRenderer.settings.enabled.getValue().booleanValue() && isHud) {
            return;
        }
        CooldownRenderType type = CooldownRenderer.settings.cooldownRenderType.getValue();
        switch (type) {
            case LIST: {
                cooldownItemsList.render(matrixStack, isHud);
                break;
            }
            case ICONS: {
                CooldownRenderer.renderIcons(matrixStack, isHud);
            }
        }
    }

    public static void resetAllAnim() {
        cooldownItemsList.resetAnim();
        for (AbstractItemCooldown itemCooldown : ItemsCategory.getCurrentCategory().getItems()) {
            itemCooldown.resetAnim();
        }
    }

    public static void renderIcons(class_4587 matrixStack, boolean isHud) {
        ItemsCategory selectedCategory;
        List<ItemsCategory> items = CooldownRenderer.settings.items.getValue();
        if (!items.contains(selectedCategory = ItemsCategory.getCurrentCategory())) {
            return;
        }
        for (AbstractItemCooldown item : selectedCategory.getItems()) {
            item.render(matrixStack, isHud);
        }
    }
}

