/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.hud;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;
import me.zyouime.itemcooldown.render.RenderHelper;
import me.zyouime.itemcooldown.render.animation.Anim;
import me.zyouime.itemcooldown.render.animation.EaseAnim;
import me.zyouime.itemcooldown.render.font.FontRenderers;
import me.zyouime.itemcooldown.screen.widget.impl.option.entry.api.Animation;
import me.zyouime.itemcooldown.setting.Settings;
import me.zyouime.itemcooldown.util.WidgetAnim;
import me.zyouime.itemcooldown.util.helper.ColorHelper;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class CooldownItemsList
implements Animation {
    private final Map<AbstractItemCooldown, CooldownSlot> slots = new LinkedHashMap<AbstractItemCooldown, CooldownSlot>();
    private float x;
    private float y;
    private float width;
    private float height;
    private float animWidth;
    private float animHeight;
    private final EaseAnim anim = new EaseAnim(7);

    public CooldownItemsList(Settings settings) {
        this.x = settings.cooldownListPos.getValue().x;
        this.y = settings.cooldownListPos.getValue().y;
    }

    public void addSlot(AbstractItemCooldown item) {
        this.slots.put(item, new CooldownSlot(item));
    }

    public void clear() {
        this.slots.clear();
    }

    public void tick() {
        this.slots.values().removeIf(slot -> {
            AbstractItemCooldown itemCooldown = ((CooldownSlot)slot).item;
            return itemCooldown.getCooldown() < 0 && ((CooldownSlot)slot).anim.getAnimationd() == 0.0;
        });
    }

    public void render(class_4587 matrixStack, boolean isHud) {
        this.updateAnim(isHud);
        float animProgress = (float)this.anim.getAnimationd();
        class_1041 window = class_310.method_1551().method_22683();
        float sWidth = window.method_4486();
        float sHeight = window.method_4502();
        float centerX = sWidth / 2.0f;
        float centerY = sHeight / 2.0f;
        float maxX = sWidth - this.animWidth;
        float maxY = sHeight - this.animHeight;
        float renderX = Math.max(0.0f, Math.min(centerX + this.x, maxX));
        float renderY = Math.max(0.0f, Math.min(centerY + this.y, maxY));
        WidgetAnim arcAnim = WidgetAnim.getAnim(renderX, renderY, this.animWidth, this.animHeight, 6.0f, animProgress);
        WidgetAnim backAnim = WidgetAnim.getAnim(renderX + 1.0f, renderY + 1.0f, this.animWidth - 2.0f, this.animHeight - 2.0f, 5.0f, animProgress);
        RenderHelper.drawArcAndBackground(matrixStack, arcAnim, backAnim, animProgress, true);
        RenderHelper.drawAnimatedText(matrixStack, "TopkaCooldown", renderX + 5.0f, renderY + 8.0f, animProgress, 1.0f, Color.WHITE);
        float offsetY = renderY + 20.0f;
        for (CooldownSlot slot : this.slots.values()) {
            if (!slot.getItem().isVisible()) continue;
            slot.updatePos(renderX, offsetY, this.animWidth);
            slot.render(matrixStack);
            offsetY += 17.0f;
        }
    }

    @Override
    public void updateAnim(boolean bl) {
        boolean hasVisibleSlots = this.slots.values().stream().anyMatch(slot -> slot.getItem().isVisibleAndCooldown());
        boolean hasAnimatingSlots = this.slots.values().stream().anyMatch(slot -> ((CooldownSlot)slot).anim.getAnimationd() > 0.0);
        boolean update = !bl || hasVisibleSlots || hasAnimatingSlots;
        this.anim.update(update);
        boolean slotUpdate = this.anim.getAnimationd() == 1.0;
        for (CooldownSlot slot2 : this.slots.values()) {
            slot2.updateAnim(slotUpdate);
        }
        this.updateSize();
    }

    @Override
    public void updateAnim() {
    }

    @Override
    public void resetAnim() {
        this.anim.reset();
        for (CooldownSlot slot : this.slots.values()) {
            slot.resetAnim();
        }
    }

    public void updateSize() {
        this.height = this.slots.isEmpty() ? 23.0f : (float)(23 + (int)this.slots.values().stream().filter(slot -> slot.getItem().isVisible()).count() * 17);
        float maxWidth = this.slots.values().stream().map(slot -> Float.valueOf(slot.getItem().getListWidth())).max(Float::compare).orElse(Float.valueOf(100.0f)).floatValue();
        this.width = Math.max(100.0f, maxWidth);
        this.animHeight = Anim.fast(this.animHeight, this.height, 40.0f);
        this.animWidth = Anim.fast(this.animWidth, this.width, 40.0f);
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setAnimWidth(float animWidth) {
        this.animWidth = animWidth;
    }

    public void setAnimHeight(float animHeight) {
        this.animHeight = animHeight;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getAnimWidth() {
        return this.animWidth;
    }

    public float getAnimHeight() {
        return this.animHeight;
    }

    public static class CooldownSlot
    implements Animation {
        private final AbstractItemCooldown item;
        private final EaseAnim anim = new EaseAnim(7);
        private float x;
        private float y;
        private float width;

        public CooldownSlot(AbstractItemCooldown item) {
            this.item = item;
        }

        public void updatePos(float x, float y, float width) {
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public void render(class_4587 matrixStack) {
            float animProgress = (float)this.anim.getAnimationd();
            WidgetAnim borderAnim = WidgetAnim.getAnim(this.x + 19.0f, this.y + 2.0f, 1.0f, 12.0f, 1.0f, animProgress);
            String cooldown = Integer.toString(this.item.getCooldown() / 20);
            float cooldownWidth = FontRenderers.mainFont.getWidth(cooldown);
            float f = this.x + this.width - cooldownWidth / 2.0f - 5.8f;
            WidgetAnim timerBackAnim = WidgetAnim.getAnim(f - cooldownWidth / 2.0f - 2.0f, this.y + 3.0f, cooldownWidth + 4.0f, FontRenderers.mainFont.getFontHeight(), 3.0f, animProgress);
            RenderHelper.drawRoundedRect(matrixStack, timerBackAnim.x, timerBackAnim.y, timerBackAnim.width, timerBackAnim.height, timerBackAnim.radius, ColorHelper.injectAlpha(Color.GRAY, 90.0f));
            RenderHelper.drawCenteredAnimatedText(matrixStack, cooldown, f, this.y + 4.0f, animProgress, this.item.getTimerColor(), 0.9f);
            RenderHelper.drawRoundedRect(matrixStack, borderAnim.x, borderAnim.y, borderAnim.width, borderAnim.height, borderAnim.radius, Color.GRAY);
            RenderHelper.drawAnimatedItem(matrixStack, this.item.getItemStack(), this.x + 2.0f, this.y, animProgress, 0.8f);
            RenderHelper.drawAnimatedText(matrixStack, this.item.getCustomName(), this.x + 22.0f, this.y + 5.5f, animProgress, 0.92f, Color.WHITE);
        }

        @Override
        public void updateAnim(boolean bl) {
            this.anim.update(bl && this.item.isVisibleAndCooldown());
        }

        @Override
        public void updateAnim() {
        }

        @Override
        public void resetAnim() {
            this.anim.reset();
        }

        public AbstractItemCooldown getItem() {
            return this.item;
        }
    }
}

