/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.itemcooldown.category;

import com.google.gson.annotations.Expose;
import java.util.List;
import me.zyouime.itemcooldown.client.ItemCooldown;
import me.zyouime.itemcooldown.item.AbstractItemCooldown;

public class ItemsCategory {
    @Expose
    private final String name;
    @Expose
    private final List<AbstractItemCooldown> items;

    public ItemsCategory(String name, List<AbstractItemCooldown> items) {
        this.name = name;
        this.items = items;
    }

    public static ItemsCategory getCurrentCategory() {
        return ItemsCategory.getCategoryFromList(ItemCooldown.getInstance().settings.selectedCategory.getValue());
    }

    public static ItemsCategory getCategoryFromList(String name) {
        for (ItemsCategory category : ItemCooldown.getInstance().settings.items.getValue()) {
            if (!category.name.equals(name)) continue;
            return category;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemsCategory) {
            return ((ItemsCategory)obj).name.equals(this.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public List<AbstractItemCooldown> getItems() {
        return this.items;
    }
}

