/*
 * Decompiled with CFR 0.152.
 */
package me.zyouime.savektleave.mixin;

import com.mojang.authlib.GameProfile;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.zyouime.savektleave.client.SaveKtLeaveClient;
import me.zyouime.savektleave.manager.PvPManager;
import me.zyouime.savektleave.manager.SaveKtManager;
import me.zyouime.savektleave.util.ClientPlayNetworkHandlerHelper;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2749;
import net.minecraft.class_2797;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class ClientPlayNetworkHandlerMixin
implements ClientPlayNetworkHandlerHelper {
    @Shadow
    @Final
    private class_310 field_3690;
    @Unique
    private boolean zalupka;
    @Unique
    private ScheduledExecutorService commandService;
    @Unique
    private ScheduledFuture<?> commandTask;

    @Shadow
    public abstract void method_2883(class_2596<?> var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(class_310 client, class_437 screen, class_2535 connection, GameProfile profile, CallbackInfo ci) {
        this.commandService = Executors.newSingleThreadScheduledExecutor();
    }

    @Inject(method={"sendPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendPacket(class_2596<?> packet, CallbackInfo ci) {
        if (packet instanceof class_2797) {
            SaveKtManager saveKtManager = SaveKtLeaveClient.getInstance().saveKtManager;
            String command = ((class_2797)packet).method_12114().toLowerCase().trim();
            if (!saveKtManager.COMMANDS_FOR_LEAVE.contains(command)) {
                return;
            }
            if (this.zalupka) {
                return;
            }
            ci.cancel();
            this.coolProtectFromHub(command);
        }
    }

    @Inject(method={"onHealthUpdate"}, at={@At(value="RETURN")})
    private void onHealthUpdate(class_2749 packet, CallbackInfo ci) {
        if (packet.method_11833() <= 0.0f) {
            SaveKtLeaveClient.getInstance().saveKtManager.reset();
        }
    }

    @Unique
    private void sendConfirmScreen(String command) {
        SaveKtManager saveKtManager = SaveKtLeaveClient.getInstance().saveKtManager;
        saveKtManager.reset();
        this.field_3690.execute(() -> saveKtManager.checkLeaveCommand(command));
    }

    @Unique
    private void coolProtectFromHub(String command) {
        SaveKtManager saveKtManager = SaveKtLeaveClient.getInstance().saveKtManager;
        PvPManager pvPManager = SaveKtLeaveClient.getInstance().pvpManager;
        this.commandTask = this.commandService.scheduleWithFixedDelay(() -> {
            if (saveKtManager.lastAttack && pvPManager.isPvp()) {
                this.sendConfirmScreen(command);
                this.removeTask();
            } else if (!saveKtManager.lastAttack) {
                if (pvPManager.isPvp()) {
                    this.sendConfirmScreen(command);
                    this.removeTask();
                } else {
                    this.sendFinalCommand(command);
                    this.removeTask();
                }
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    @Unique
    private void removeTask() {
        if (this.commandTask != null) {
            this.commandTask.cancel(true);
        }
    }

    @Override
    public void sendFinalCommand(String command) {
        this.field_3690.execute(() -> {
            this.zalupka = true;
            this.method_2883((class_2596<?>)new class_2797(command));
            this.zalupka = false;
        });
    }
}

