/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.ui;

import dev.sxmurxy.topkahitboxes.animations.EaseAnimation;
import dev.sxmurxy.topkahitboxes.helpers.font.FontRenderer;
import dev.sxmurxy.topkahitboxes.helpers.misc.ColorHelper;
import dev.sxmurxy.topkahitboxes.helpers.misc.HoverUtil;
import dev.sxmurxy.topkahitboxes.helpers.misc.MathHelper;
import dev.sxmurxy.topkahitboxes.helpers.render.DrawHelper;
import dev.sxmurxy.topkahitboxes.settings.impl.ColorSetting;
import dev.sxmurxy.topkahitboxes.ui.Button;
import dev.sxmurxy.topkahitboxes.ui.Element;
import dev.sxmurxy.topkahitboxes.ui.GuiScreen;
import java.awt.Color;
import net.minecraft.class_4587;

public class ColorPicker
extends Element {
    private EaseAnimation moveXAnim = new EaseAnimation(EaseAnimation.Type.OUT);
    private final double sliderHeight = 64.0;
    private final double radius = 33.0;
    private final double sliderWidth = 3.0;
    private double centerX;
    private double centerY;
    private double pointerX;
    private double pointerY;
    private double xp;
    private double sy;
    private double brightnessX;
    private double saturationX;
    private double alphaX;
    private boolean opened;
    private boolean pointerDragging;
    private boolean brightnessDragging;
    private boolean saturationDragging;
    private boolean alphaDragging;
    private float hue;
    private float saturation;
    private float brightness;
    private float alpha;
    private ColorSetting setting;
    private Button copy = new Button(34.0, 15.0, "Copy", () -> ColorPicker.MC.field_1774.method_1455(this.convert()), (matrices, x, y, width, height, title) -> {
        DrawHelper.drawRoundedRect(x, y, width, height, 4.0, GuiScreen.BACKGROUND_SECONDARY);
        FontRenderer.drawCenteredXYString(matrices, DEFAULT_20, title, x + width / 2.0, y - height / 2.0, Color.WHITE);
    });
    private Button paste = new Button(34.0, 15.0, "Paste", () -> this.parse(ColorPicker.MC.field_1774.method_1460()), (matrices, x, y, width, height, title) -> {
        DrawHelper.drawRoundedRect(x, y, width, height, 4.0, GuiScreen.BACKGROUND_SECONDARY);
        FontRenderer.drawCenteredXYString(matrices, DEFAULT_20, title, x + width / 2.0, y - height / 2.0, Color.WHITE);
    });

    public ColorPicker() {
        super(160.0, 130.0, "");
    }

    @Override
    public void render(class_4587 matrices, double mouseX, double mouseY) {
        if (this.pointerDragging) {
            this.setPointerDraggingPos(mouseX, mouseY);
        } else if (this.brightnessDragging) {
            this.brightness = (float)(this.calculateSliderY(mouseY) / 64.0);
            this.saveValue();
        } else if (this.saturationDragging) {
            this.saturation = (float)(this.calculateSliderY(mouseY) / 64.0);
            this.calculatePointerPosition();
            this.saveValue();
        } else if (this.alphaDragging) {
            this.alpha = (float)(this.calculateSliderY(mouseY) / 64.0);
            this.saveValue();
        }
        if (this.moveXAnim.isAnimating()) {
            this.x = this.moveXAnim.getAndUpdate();
            this.update();
        }
        DrawHelper.drawGlow(this.x, this.y, (int)this.width, (int)this.height, 14, Color.BLACK);
        DrawHelper.drawRoundedRect(this.x, this.y, this.width, this.height, 5.0, GuiScreen.BACKGROUND_PRIMARY);
        DrawHelper.drawRoundedRect(this.x + 95.0, this.sy + 3.0, 52.0, 73.0, 1.5, GuiScreen.BACKGROUND_SECONDARY);
        FontRenderer.drawCenteredXYString(matrices, DEFAULT_24, this.title, this.x + this.width / 2.0, this.y - this.height + 10.0, Color.WHITE);
        FontRenderer.drawString(matrices, ICONS_22, "b", this.x + this.width - 18.0, this.y - this.height + 17.0, HoverUtil.hovered(mouseX, mouseY, this.x + this.width - 20.5, this.y - this.height + 19.0, 15.0, 16.0) ? Color.RED : Color.WHITE);
        DrawHelper.drawRainbowCircle(this.centerX, this.centerY, 33.0, 2.0);
        DrawHelper.drawCircleOutline(this.xp + this.pointerX, this.sy - this.pointerY, 3.0, 2.0f, GuiScreen.BACKGROUND_SECONDARY);
        this.drawSlider(this.brightnessX, this.brightness, Color.BLACK, Color.getHSBColor(this.hue, this.saturation, 1.0f));
        this.drawSlider(this.saturationX, this.saturation, Color.WHITE, Color.getHSBColor(this.hue, 1.0f, this.brightness));
        Color aColor = Color.getHSBColor(this.hue, this.saturation, this.brightness);
        this.drawSlider(this.alphaX, this.alpha, ColorHelper.injectAlpha(aColor, 15), aColor);
        this.copy.render(matrices, mouseX, mouseY);
        this.paste.render(matrices, mouseX, mouseY);
        Color color = (Color)this.setting.getValue();
        DrawHelper.drawRoundedRect(this.x + 95.0, this.y - 7.0, 52.0, 15.0, 4.0, GuiScreen.BACKGROUND_SECONDARY);
        DrawHelper.drawRoundedRect(this.x + 95.0, this.y - 7.0, 52.0, 15.0, 4.0, color);
        FontRenderer.drawCenteredXYString(matrices, DEFAULT_20, ColorHelper.hex(color), this.x + 121.0, this.y - 14.5, new Color(1.0f - this.brightness, 1.0f - this.brightness, 1.0f - this.brightness));
    }

    private void drawSlider(double x, float value, Color color1, Color color2) {
        DrawHelper.drawRoundedGradientRect(x, this.sy - 1.0, 3.0, 64.0, 1.0, color2, color1, color2, color1);
        DrawHelper.drawCircle(x + 1.5, this.sy - (double)value * 64.0 - 1.5, 3.0, Color.WHITE);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.moveXAnim.isAnimating()) {
            return false;
        }
        if (HoverUtil.hovered(mouseX, mouseY, this.x + this.width - 20.5, this.y - this.height + 19.0, 15.5, 16.0)) {
            this.moveXAnim.begin(this.x, GuiScreen.getScaledWidth() / 2.0 - 182.0, 1.1, () -> {
                this.opened = false;
            });
        } else if (HoverUtil.hovered(mouseX, mouseY, this.centerX, this.centerY, 33.0)) {
            this.pointerDragging = true;
        } else if (HoverUtil.hovered(mouseX, mouseY, this.brightnessX - 3.0, this.sy - 1.0, 9.0, 64.0)) {
            this.brightnessDragging = true;
        } else if (HoverUtil.hovered(mouseX, mouseY, this.saturationX - 3.0, this.sy - 1.0, 9.0, 64.0)) {
            this.saturationDragging = true;
        } else if (HoverUtil.hovered(mouseX, mouseY, this.alphaX - 3.0, this.sy - 1.0, 9.0, 64.0)) {
            this.alphaDragging = true;
        }
        this.copy.mouseClicked(mouseX, mouseY, mouseButton);
        this.paste.mouseClicked(mouseX, mouseY, mouseButton);
        return true;
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.pointerDragging = false;
        this.saturationDragging = false;
        this.brightnessDragging = false;
        this.alphaDragging = false;
    }

    private void calculatePointerPosition() {
        double y1;
        double x1;
        double angle = Math.PI * 2 * (double)this.hue;
        double h = (double)this.saturation * 33.0;
        if (angle >= 4.71238898038469) {
            x1 = Math.cos(angle - 4.71238898038469) * h;
            y1 = MathHelper.cathet(h, x1);
        } else if (angle >= Math.PI) {
            x1 = Math.sin(angle - Math.PI) * h;
            y1 = -MathHelper.cathet(h, x1);
        } else if (angle >= 1.5707963267948966) {
            x1 = -Math.cos(angle - 1.5707963267948966) * h;
            y1 = -MathHelper.cathet(h, x1);
        } else {
            x1 = -Math.sin(angle) * h;
            y1 = MathHelper.cathet(h, x1);
        }
        this.pointerX = 33.0 - x1;
        this.pointerY = 33.0 - y1;
    }

    private void calculateColor() {
        double h = Math.sqrt(MathHelper.sq(this.pointerX - 33.0) + MathHelper.sq(33.0 - this.pointerY));
        double c = this.pointerX - 33.0;
        double angle = this.pointerX >= 33.0 && this.pointerY < 33.0 ? Math.asin(c / h) : (this.pointerX >= 33.0 && this.pointerY > 33.0 ? 1.5707963267948966 + Math.acos(c / h) : (this.pointerX < 33.0 && this.pointerY >= 33.0 ? Math.PI + Math.asin(-c / h) : 4.71238898038469 + Math.acos(-c / h)));
        this.hue = (float)(angle / (Math.PI * 2));
        this.saturation = (float)(h / 33.0);
        this.saveValue();
    }

    private void setPointerDraggingPos(double mouseX, double mouseY) {
        if (!HoverUtil.hovered(mouseX, mouseY, this.centerX, this.centerY, 33.0)) {
            double y1;
            double x1;
            double dX = mouseX - this.centerX;
            double dY = mouseY - this.centerY;
            if (mouseX >= this.centerX && mouseY >= this.centerY) {
                double angle = -Math.atan(dX / dY);
                x1 = Math.sin(angle) * 33.0;
                y1 = MathHelper.cathet(33.0, x1);
            } else if (mouseX >= this.centerX && mouseY < this.centerY) {
                double angle = Math.atan(dY / dX);
                x1 = -Math.cos(angle) * 33.0;
                y1 = -MathHelper.cathet(33.0, x1);
            } else if (mouseX < this.centerX && mouseY < this.centerY) {
                double angle = Math.atan(dX / dY);
                x1 = Math.sin(angle) * 33.0;
                y1 = -MathHelper.cathet(33.0, x1);
            } else {
                double angle = -Math.atan(dY / dX);
                x1 = Math.cos(angle) * 33.0;
                y1 = MathHelper.cathet(33.0, x1);
            }
            this.pointerX = 33.0 - x1;
            this.pointerY = 33.0 - y1;
        } else {
            this.pointerX = mouseX - this.xp;
            this.pointerY = this.sy - mouseY;
        }
        this.calculateColor();
    }

    @Override
    public void init() {
        if (!this.moveXAnim.isAnimating() && this.opened) {
            this.x = GuiScreen.getScaledWidth() / 2.0 + 15.0;
            this.update();
        }
        this.y = (GuiScreen.getScaledHeight() + this.height) / 2.0 - 15.0;
        this.centerY = this.y - 66.0;
        this.sy = this.y - 33.0;
        this.copy.setY(this.y - 7.0);
        this.paste.setY(this.y - 7.0);
    }

    @Override
    public void onClose() {
        this.mouseReleased(0.0, 0.0, 0);
    }

    private double calculateSliderY(double mouseY) {
        return mouseY >= this.sy - 1.0 ? 1.0 : Math.min(63.0, this.sy - 1.0 - mouseY);
    }

    private void saveValue() {
        this.setting.setValue(ColorHelper.injectAlpha(Color.getHSBColor(this.hue, this.saturation, this.brightness), this.alpha));
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void parse(String content) {
        try {
            String[] comps = content.split(" ");
            if (comps.length >= 3) {
                int r = Integer.valueOf(comps[0]);
                int g = Integer.valueOf(comps[1]);
                int b = Integer.valueOf(comps[2]);
                int a = comps.length >= 4 ? Integer.valueOf(comps[3]) : 255;
                this.apply(new Color(r, g, b, a));
                this.saveValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String convert() {
        Color color = (Color)this.setting.getValue();
        return String.format("%d %d %d %d", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public void toggle(ColorSetting setting) {
        if (this.opened) {
            if (this.setting == setting) {
                this.moveXAnim.begin(this.x, GuiScreen.getScaledWidth() / 2.0 - 182.0, 1.1, () -> {
                    this.opened = false;
                });
            } else {
                this.moveXAnim.begin(this.x, GuiScreen.getScaledWidth() / 2.0 - 182.0, 1.1, () -> {
                    this.create(setting);
                    this.moveXAnim.begin(this.x, GuiScreen.getScaledWidth() / 2.0 + 15.0, 1.1);
                });
            }
        } else {
            if (this.setting == setting) {
                this.opened = true;
            } else {
                this.create(setting);
            }
            this.moveXAnim.begin(GuiScreen.getScaledWidth() / 2.0 - 182.0, GuiScreen.getScaledWidth() / 2.0 + 15.0, 1.1);
        }
    }

    private void create(ColorSetting setting) {
        this.setting = setting;
        this.title = setting.getTitle();
        this.apply((Color)setting.getValue());
        this.calculatePointerPosition();
        this.opened = true;
    }

    private void apply(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.alpha = (float)color.getAlpha() / 255.0f;
        this.calculatePointerPosition();
    }

    private void update() {
        this.centerX = this.x + 47.0;
        this.xp = this.x + 14.0;
        this.brightnessX = this.x + 95.0 + 7.0;
        this.saturationX = this.x + 95.0 + 24.5;
        this.alphaX = this.x + 95.0 + 42.0;
        this.copy.setX(this.x + 11.0);
        this.paste.setX(this.x + 49.0);
    }
}

