/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.helpers.render;

import dev.sxmurxy.topkahitboxes.TopkaHitboxes;
import dev.sxmurxy.topkahitboxes.Wrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.stream.Collectors;
import net.minecraft.class_4493;
import org.lwjgl.opengl.GL30;

public class Shader
implements Wrapper {
    public static final int VERTEX_SHADER = class_4493.method_22035((int)35633);
    private int programId;

    public Shader(String fragmentShaderName) {
        int programId = class_4493.method_22062();
        try {
            int fragmentShader = class_4493.method_22035((int)35632);
            class_4493.method_21961((int)fragmentShader, (CharSequence)Shader.getShaderSource(fragmentShaderName));
            class_4493.method_22041((int)fragmentShader);
            int isFragmentCompiled = GL30.glGetShaderi((int)fragmentShader, (int)35713);
            if (isFragmentCompiled == 0) {
                class_4493.method_22029((int)fragmentShader);
                System.err.println("Fragment shader couldn't compile. It has been deleted.");
            }
            class_4493.method_22016((int)programId, (int)VERTEX_SHADER);
            class_4493.method_22016((int)programId, (int)fragmentShader);
            class_4493.method_22051((int)programId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.programId = programId;
    }

    public void load() {
        class_4493.method_22045((int)this.programId);
    }

    public void unload() {
        class_4493.method_22045((int)0);
    }

    public int getUniform(String name) {
        return GL30.glGetUniformLocation((int)this.programId, (CharSequence)name);
    }

    public void setUniformf(String name, float ... args) {
        int loc = GL30.glGetUniformLocation((int)this.programId, (CharSequence)name);
        switch (args.length) {
            case 1: {
                GL30.glUniform1f((int)loc, (float)args[0]);
                break;
            }
            case 2: {
                GL30.glUniform2f((int)loc, (float)args[0], (float)args[1]);
                break;
            }
            case 3: {
                GL30.glUniform3f((int)loc, (float)args[0], (float)args[1], (float)args[2]);
                break;
            }
            case 4: {
                GL30.glUniform4f((int)loc, (float)args[0], (float)args[1], (float)args[2], (float)args[3]);
            }
        }
    }

    public void setUniformi(String name, int ... args) {
        int loc = GL30.glGetUniformLocation((int)this.programId, (CharSequence)name);
        switch (args.length) {
            case 1: {
                GL30.glUniform1i((int)loc, (int)args[0]);
                break;
            }
            case 2: {
                GL30.glUniform2i((int)loc, (int)args[0], (int)args[1]);
                break;
            }
            case 3: {
                GL30.glUniform3i((int)loc, (int)args[0], (int)args[1], (int)args[2]);
                break;
            }
            case 4: {
                GL30.glUniform4i((int)loc, (int)args[0], (int)args[1], (int)args[2], (int)args[3]);
            }
        }
    }

    public void setUniformfb(String name, FloatBuffer buffer) {
        GL30.glUniform1fv((int)GL30.glGetUniformLocation((int)this.programId, (CharSequence)name), (FloatBuffer)buffer);
    }

    public static void draw(double x, double y, double width, double height) {
        GL30.glBegin((int)7);
        GL30.glTexCoord2d((double)0.0, (double)0.0);
        GL30.glVertex2d((double)x, (double)y);
        GL30.glTexCoord2d((double)0.0, (double)1.0);
        GL30.glVertex2d((double)x, (double)(y + height));
        GL30.glTexCoord2d((double)1.0, (double)1.0);
        GL30.glVertex2d((double)(x + width), (double)(y + height));
        GL30.glTexCoord2d((double)1.0, (double)0.0);
        GL30.glVertex2d((double)(x + width), (double)y);
        GL30.glEnd();
    }

    public static String getShaderSource(String fileName) {
        String source = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(TopkaHitboxes.class.getResourceAsStream("/assets/topkahitboxes/shaders/" + fileName)));
        source = bufferedReader.lines().filter(str -> !str.isEmpty()).map(str -> {
            str = str.replace("\t", "");
            return str;
        }).collect(Collectors.joining("\n"));
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return source;
    }

    static {
        class_4493.method_21961((int)VERTEX_SHADER, (CharSequence)Shader.getShaderSource("vertex.vert"));
        class_4493.method_22041((int)VERTEX_SHADER);
    }
}

