/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.helpers.render;

import dev.sxmurxy.topkahitboxes.Wrapper;
import dev.sxmurxy.topkahitboxes.helpers.misc.ColorHelper;
import dev.sxmurxy.topkahitboxes.helpers.misc.TextureHelper;
import dev.sxmurxy.topkahitboxes.helpers.render.GlowFilter;
import dev.sxmurxy.topkahitboxes.helpers.render.Shader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.minecraft.class_4493;
import org.lwjgl.opengl.GL30;

public class DrawHelper
implements Wrapper {
    public static final HashMap<Integer, Integer> glowCache = new HashMap();
    private static final Shader ROUNDED = new Shader("rounded.frag");
    private static final Shader ROUNDED_GRADIENT = new Shader("rounded_gradient.frag");
    public static final int STEPS = 60;
    public static final double ANGLE = 0.10471975511965977;
    public static final int EX_STEPS = 120;
    public static final double EX_ANGLE = 0.05235987755982988;

    public static void preInit() {
        ROUNDED.toString();
        ROUNDED_GRADIENT.toString();
        DrawHelper.getGlowTexture(174, 190, 14);
        DrawHelper.getGlowTexture(160, 130, 14);
    }

    public static void postInit() {
        DrawHelper.getGlowTexture(10, 10, 7);
        DrawHelper.getGlowTexture(134, 32, 15);
        DrawHelper.getGlowTexture(10, 20, 20);
    }

    public static void drawCircle(double x, double y, double radius, Color color) {
        int i;
        DrawHelper.drawSetup();
        DrawHelper.applyColor(color);
        GL30.glBegin((int)6);
        for (i = 0; i <= 60; ++i) {
            GL30.glVertex2d((double)(x + radius * Math.sin(0.10471975511965977 * (double)i)), (double)(y + radius * Math.cos(0.10471975511965977 * (double)i)));
        }
        GL30.glEnd();
        GL30.glLineWidth((float)1.5f);
        GL30.glEnable((int)2848);
        GL30.glBegin((int)2);
        for (i = 0; i <= 60; ++i) {
            GL30.glVertex2d((double)(x + radius * Math.sin(0.10471975511965977 * (double)i)), (double)(y + radius * Math.cos(0.10471975511965977 * (double)i)));
        }
        GL30.glEnd();
        GL30.glDisable((int)2848);
        DrawHelper.drawFinish();
    }

    public static void drawCircleOutline(double x, double y, double radius, float thikness, Color color) {
        DrawHelper.drawSetup();
        GL30.glEnable((int)2848);
        GL30.glLineWidth((float)thikness);
        DrawHelper.applyColor(color);
        GL30.glBegin((int)2);
        for (int i = 0; i <= 60; ++i) {
            GL30.glVertex2d((double)(x + radius * Math.sin(0.10471975511965977 * (double)i)), (double)(y + radius * Math.cos(0.10471975511965977 * (double)i)));
        }
        GL30.glEnd();
        GL30.glDisable((int)2848);
        DrawHelper.drawFinish();
    }

    public static void drawRainbowCircle(double x, double y, double radius, double blurRadius) {
        int i;
        DrawHelper.drawSetup();
        GL30.glEnable((int)3008);
        GL30.glAlphaFunc((int)516, (float)1.0E-4f);
        GL30.glShadeModel((int)7425);
        DrawHelper.applyColor(Color.WHITE);
        GL30.glBegin((int)6);
        GL30.glVertex2d((double)x, (double)y);
        for (i = 0; i <= 120; ++i) {
            DrawHelper.applyColor(Color.getHSBColor((float)i / 120.0f, 1.0f, 1.0f));
            GL30.glVertex2d((double)(x + radius * Math.sin(0.05235987755982988 * (double)i)), (double)(y + radius * Math.cos(0.05235987755982988 * (double)i)));
        }
        GL30.glEnd();
        GL30.glBegin((int)5);
        for (i = 0; i <= 121; ++i) {
            if (i % 2 == 1) {
                DrawHelper.applyColor(ColorHelper.injectAlpha(Color.getHSBColor((float)i / 120.0f, 1.0f, 1.0f), 0));
                GL30.glVertex2d((double)(x + (radius + blurRadius) * Math.sin(0.05235987755982988 * (double)i)), (double)(y + (radius + blurRadius) * Math.cos(0.05235987755982988 * (double)i)));
                continue;
            }
            DrawHelper.applyColor(Color.getHSBColor((float)i / 120.0f, 1.0f, 1.0f));
            GL30.glVertex2d((double)(x + radius * Math.sin(0.05235987755982988 * (double)i)), (double)(y + radius * Math.cos(0.05235987755982988 * (double)i)));
        }
        GL30.glEnd();
        GL30.glShadeModel((int)7424);
        GL30.glDisable((int)3008);
        DrawHelper.drawFinish();
    }

    public static void drawRect(double x, double y, double width, double height, Color color) {
        DrawHelper.drawSetup();
        DrawHelper.applyColor(color);
        GL30.glBegin((int)7);
        GL30.glVertex2d((double)x, (double)y);
        GL30.glVertex2d((double)(x + width), (double)y);
        GL30.glVertex2d((double)(x + width), (double)(y - height));
        GL30.glVertex2d((double)x, (double)(y - height));
        GL30.glEnd();
        DrawHelper.drawFinish();
    }

    public static void drawRoundedRect(double x, double y, double width, double height, double radius, Color color) {
        float[] c = ColorHelper.getColorCompsf(color);
        DrawHelper.drawSetup();
        ROUNDED.load();
        ROUNDED.setUniformf("size", (float)width * 2.0f, (float)height * 2.0f);
        ROUNDED.setUniformf("round", (float)radius * 2.0f);
        ROUNDED.setUniformf("color", c[0], c[1], c[2], c[3]);
        Shader.draw(x, y - height, width, height);
        ROUNDED.unload();
        DrawHelper.drawFinish();
    }

    public static void drawRoundedGradientRect(double x, double y, double width, double height, double radius, Color ... colors) {
        float[] c = ColorHelper.getColorCompsf(colors[0]);
        float[] c1 = ColorHelper.getColorCompsf(colors[1]);
        float[] c2 = ColorHelper.getColorCompsf(colors[2]);
        float[] c3 = ColorHelper.getColorCompsf(colors[3]);
        DrawHelper.drawSetup();
        ROUNDED_GRADIENT.load();
        ROUNDED_GRADIENT.setUniformf("size", (float)width * 2.0f, (float)height * 2.0f);
        ROUNDED_GRADIENT.setUniformf("round", (float)radius * 2.0f);
        ROUNDED_GRADIENT.setUniformf("color1", c[0], c[1], c[2], c[3]);
        ROUNDED_GRADIENT.setUniformf("color2", c1[0], c1[1], c1[2], c1[3]);
        ROUNDED_GRADIENT.setUniformf("color3", c2[0], c2[1], c2[2], c2[3]);
        ROUNDED_GRADIENT.setUniformf("color4", c3[0], c3[1], c3[2], c3[3]);
        Shader.draw(x, y - height, width, height);
        ROUNDED_GRADIENT.unload();
        DrawHelper.drawFinish();
    }

    public static void drawGlow(double x, double y, int width, int height, int glowRadius, Color color) {
        class_4493.method_22056();
        class_4493.method_21984((int)770, (int)771);
        GL30.glEnable((int)3008);
        GL30.glAlphaFunc((int)516, (float)1.0E-4f);
        class_4493.method_22081((int)DrawHelper.getGlowTexture(width, height, glowRadius));
        width += glowRadius * 2;
        DrawHelper.applyColor(color);
        GL30.glBegin((int)7);
        GL30.glTexCoord2d((double)0.0, (double)1.0);
        GL30.glVertex2d((double)(x -= (double)glowRadius), (double)(y -= (double)((height += glowRadius * 2) - glowRadius)));
        GL30.glTexCoord2d((double)0.0, (double)0.0);
        GL30.glVertex2d((double)x, (double)(y + (double)height));
        GL30.glTexCoord2d((double)1.0, (double)0.0);
        GL30.glVertex2d((double)(x + (double)width), (double)(y + (double)height));
        GL30.glTexCoord2d((double)1.0, (double)1.0);
        GL30.glVertex2d((double)(x + (double)width), (double)y);
        GL30.glEnd();
        class_4493.method_22081((int)0);
        GL30.glDisable((int)3008);
        class_4493.method_22053();
    }

    public static int getGlowTexture(int width, int height, int blurRadius) {
        int identifier = (width * 401 + height) * 407 + blurRadius;
        int texId = glowCache.getOrDefault(identifier, -1);
        if (texId == -1) {
            BufferedImage original = new BufferedImage(width + blurRadius * 2, height + blurRadius * 2, 3);
            Graphics g = original.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(blurRadius, blurRadius, width, height);
            g.dispose();
            GlowFilter glow = new GlowFilter(blurRadius);
            BufferedImage blurred = glow.filter(original, null);
            try {
                texId = TextureHelper.loadTexture(blurred);
                glowCache.put(identifier, texId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return texId;
    }

    public static void applyColor(Color color) {
        GL30.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
    }

    public static void resetColor() {
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSetup() {
        class_4493.method_21912();
        class_4493.method_22056();
        class_4493.method_21984((int)770, (int)771);
    }

    public static void drawFinish() {
        class_4493.method_21910();
        class_4493.method_22053();
        DrawHelper.resetColor();
    }
}

