/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.helpers.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.awt.Color;

public class DataHandlers {
    public static final DataHandler<Boolean> BOOLEAN = new DataHandler<Boolean>(){

        @Override
        public Boolean read(JsonElement je) {
            return je.getAsBoolean();
        }

        @Override
        public JsonElement save(Boolean value) {
            return new JsonPrimitive(value);
        }
    };
    public static final DataHandler<Color> COLOR = new DataHandler<Color>(){

        @Override
        public Color read(JsonElement je) {
            JsonArray arr = je.getAsJsonArray();
            return new Color(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt(), arr.get(3).getAsInt());
        }

        @Override
        public JsonElement save(Color value) {
            JsonArray arr = new JsonArray();
            arr.add((Number)value.getRed());
            arr.add((Number)value.getGreen());
            arr.add((Number)value.getBlue());
            arr.add((Number)value.getAlpha());
            return arr;
        }
    };
    public static final DataHandler<Float> FLOAT = new DataHandler<Float>(){

        @Override
        public Float read(JsonElement je) {
            return Float.valueOf(je.getAsFloat());
        }

        @Override
        public JsonElement save(Float value) {
            return new JsonPrimitive((Number)value);
        }
    };

    public static interface DataHandler<T> {
        public JsonElement save(T var1);

        public T read(JsonElement var1);
    }
}

