/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.helpers.font;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.sxmurxy.topkahitboxes.TopkaHitboxes;
import dev.sxmurxy.topkahitboxes.helpers.misc.TextureHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4493;

public class CustomFont {
    public static final class_289 TESSELLATOR = class_289.method_1348();
    public static final class_287 BUFFER_BUILDER = TESSELLATOR.method_1349();
    private Map<Character, Glyph> glyphs = new HashMap<Character, Glyph>();
    private float fontHeight;
    private float stretching;
    private float spacing;
    private float lifting;
    private int texId;
    private int imgSize;
    private String fontName;

    public CustomFont(String fileName, int size, boolean fractionalMetrics, float stretching, float spacing, float lifting) {
        String path = "/assets/topkahitboxes" + "/font/".concat(fileName);
        Font font = null;
        try {
            font = Font.createFont(0, TopkaHitboxes.class.getResourceAsStream(path)).deriveFont(0, size);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
        this.stretching = stretching;
        this.spacing = spacing;
        this.lifting = lifting;
        this.fontName = font.getFontName(Locale.ENGLISH);
        char[] chars = new char[128];
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), true, fractionalMetrics);
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (int i = 0; i <= chars.length - 1; ++i) {
            chars[i] = (char)i;
            Rectangle2D bound = font.getStringBounds(Character.toString(chars[i]), fontRenderContext);
            maxWidth = Math.max(maxWidth, bound.getWidth());
            maxHeight = Math.max(maxHeight, bound.getHeight());
        }
        this.fontHeight = (float)(maxHeight / 2.0);
        this.imgSize = (int)Math.ceil(Math.sqrt((maxHeight + 2.0) * (maxWidth + 2.0) * (double)chars.length));
        BufferedImage bufferedImage = new BufferedImage(this.imgSize, this.imgSize, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setFont(font);
        graphics.setColor(new Color(255, 255, 255, 0));
        graphics.fillRect(0, 0, this.imgSize, this.imgSize);
        graphics.setColor(Color.WHITE);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int posX = 1;
        int posY = 2;
        for (char c : chars) {
            Glyph glyph = new Glyph();
            Rectangle2D bounds = fontMetrics.getStringBounds(Character.toString(c), graphics);
            glyph.width = (int)bounds.getWidth() + 1;
            glyph.height = (int)bounds.getHeight() + 2;
            if (posX + glyph.width >= this.imgSize) {
                posX = 1;
                posY = (int)((double)posY + (maxHeight + (double)fontMetrics.getDescent() + 1.0));
            }
            glyph.x = posX;
            glyph.y = posY;
            graphics.drawString(Character.toString(c), posX, posY + fontMetrics.getAscent());
            posX += glyph.width + 6;
            this.glyphs.put(Character.valueOf(c), glyph);
        }
        RenderSystem.recordRenderCall(() -> this.loadTex(bufferedImage));
    }

    public void loadTex(BufferedImage tex) {
        try {
            this.texId = TextureHelper.loadTexture(tex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bindTex() {
        class_4493.method_22081((int)this.texId);
    }

    public void unbindTex() {
        class_4493.method_22081((int)0);
    }

    public float renderChar(class_1159 matrix, char c, float x, float y, float red, float green, float blue, float alpha) {
        Glyph glyph = this.glyphs.get(Character.valueOf(c));
        if (glyph == null) {
            return 0.0f;
        }
        float pageX = (float)glyph.x / (float)this.imgSize;
        float pageY = (float)glyph.y / (float)this.imgSize;
        float pageWidth = (float)glyph.width / (float)this.imgSize;
        float pageHeight = (float)glyph.height / (float)this.imgSize;
        float width = (float)glyph.width + this.stretching;
        float height = glyph.height;
        BUFFER_BUILDER.method_1328(7, class_290.field_20887);
        BUFFER_BUILDER.method_22918(matrix, x, y + height, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX, pageY + pageHeight).method_1344();
        BUFFER_BUILDER.method_22918(matrix, x + width, y + height, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX + pageWidth, pageY + pageHeight).method_1344();
        BUFFER_BUILDER.method_22918(matrix, x + width, y, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX + pageWidth, pageY).method_1344();
        BUFFER_BUILDER.method_22918(matrix, x, y, 0.0f).method_22915(red, green, blue, alpha).method_22913(pageX, pageY).method_1344();
        TESSELLATOR.method_1350();
        return width + this.spacing;
    }

    public float getWidth(char ch) {
        return (float)this.glyphs.get(Character.valueOf(ch)).width + this.stretching;
    }

    public float getWidth(String text) {
        float width = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            width += this.getWidth(text.charAt(i)) + this.spacing;
        }
        return (width - this.spacing) / 2.0f;
    }

    public float getLifting() {
        return this.lifting;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public String getFontName() {
        return this.fontName;
    }

    public float getFontHeight() {
        return this.fontHeight;
    }

    private static class Glyph {
        private int x;
        private int y;
        private int width;
        private int height;

        private Glyph() {
        }
    }
}

