/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.animations;

import dev.sxmurxy.topkahitboxes.animations.AbstractAnimation;

public class EaseAnimation
extends AbstractAnimation {
    private Type type;

    public EaseAnimation(Type type, double def) {
        this.type = type;
        this.now = def;
    }

    public EaseAnimation(Type type) {
        this(type, 0.0);
    }

    @Override
    public void begin(double start, double end, double speed, Runnable todo) {
        super.begin(start, end, speed, todo);
    }

    @Override
    public void begin(double start, double end, double speed) {
        super.begin(start, end, speed);
    }

    @Override
    public double getAndUpdate() {
        if (this.animating) {
            this.now = this.start + this.diff * (this.type == Type.OUT ? EaseAnimation.easeOutValue(this.getTimeFraction()) : EaseAnimation.easeInValue(this.getTimeFraction()));
            this.check();
        }
        return this.now;
    }

    private static double easeOutValue(double f) {
        return Math.pow(1.0 - f, 2.0) * 3.0 * f + (1.0 - f) * 3.0 * Math.pow(f, 2.0) * (double)0.95f + Math.pow(f, 3.0);
    }

    private static double easeInValue(double f) {
        return Math.pow(1.0 - f, 2.0) * 3.0 * f * 0.02 + (1.0 - f) * 3.0 * Math.pow(f, 2.0) + Math.pow(f, 3.0);
    }

    public static enum Type {
        OUT,
        IN;

    }
}

