/*
 * Decompiled with CFR 0.152.
 */
package dev.sxmurxy.topkahitboxes.animations;

import dev.sxmurxy.topkahitboxes.ui.GuiScreen;

public abstract class AbstractAnimation {
    protected boolean animating;
    protected double start;
    protected double diff;
    protected double now;
    protected int tick;
    protected int maxTick;
    protected Runnable todo;

    protected void begin(double start, double end, double speed, Runnable todo) {
        this.animating = true;
        this.start = start;
        this.diff = end - start;
        this.now = start;
        this.maxTick = (int)(30.0 / (speed * GuiScreen.getSpeed()));
        this.tick = 0;
        this.todo = todo;
    }

    protected void begin(double min, double max, double speed) {
        this.begin(min, max, speed, null);
    }

    public abstract double getAndUpdate();

    public double get() {
        return this.now;
    }

    public void setValue(double value) {
        this.now = value;
    }

    public double getTimeFraction() {
        this.tick = Math.min(this.tick + 1, this.maxTick);
        return (float)this.tick / (float)this.maxTick;
    }

    protected void check() {
        if (this.tick == this.maxTick) {
            this.animating = false;
            if (this.todo != null) {
                this.todo.run();
            }
        }
    }

    public void stopAndSet(double v) {
        this.animating = false;
        this.now = v;
    }

    public void stop() {
        this.animating = false;
    }

    public boolean isAnimating() {
        return this.animating;
    }
}

