/*
 * Decompiled with CFR 0.152.
 */
package ru.powerlands.highlightitems.gui;

import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import ru.powerlands.highlightitems.config.HighlightConfig;

public class HighlightConfigScreen
extends class_437 {
    private final class_437 parent;
    private float hue = 0.0f;
    private float sat = 1.0f;
    private float val = 1.0f;
    private int alpha = 255;
    private int svX;
    private int svY;
    private int svW = 220;
    private int svH = 160;
    private int hueX;
    private int hueY;
    private int hueW = 220;
    private int hueH = 16;
    private int alphaX;
    private int alphaY;
    private int alphaW = 220;
    private int alphaH = 16;
    private boolean draggingSV = false;
    private boolean draggingHue = false;
    private boolean draggingAlpha = false;
    private HighlightConfig.TrackedItem editing = null;

    public HighlightConfigScreen(class_437 parent) {
        super((class_2561)new class_2585("TopkaItemColor"));
        this.parent = parent;
    }

    protected void method_25426() {
        HighlightConfig.Root cfg = HighlightConfig.get();
        int y = this.field_22790 / 6;
        int listLeft = this.field_22789 / 2 - 210;
        int panelLeft = this.field_22789 / 2 + 10;
        int i = 0;
        for (HighlightConfig.TrackedItem t : HighlightConfig.TrackedItem.values()) {
            int idx = i++;
            boolean enabled = cfg.items.get((Object)((Object)t)).enabled;
            this.method_25411((class_339)new ItemToggleButton(listLeft, y + idx * 22, 140, 20, t, (class_2561)new class_2585(this.fitLabel(HighlightConfigScreen.toggleLabel(t, enabled), 130)), btn -> {
                boolean now;
                cfg.items.get((Object)((Object)((Object)t))).enabled = now = !cfg.items.get((Object)((Object)((Object)t))).enabled;
                btn.method_25355((class_2561)new class_2585(this.fitLabel(HighlightConfigScreen.toggleLabel(t, now), 130)));
                HighlightConfig.save();
            }));
            this.method_25411((class_339)new class_4185(listLeft + 145, y + idx * 22, 60, 20, (class_2561)new class_2585("\u0426\u0432\u0435\u0442"), btn -> {
                this.editing = t;
                this.loadHsvFromEntry(HighlightConfig.get().items.get((Object)t));
            }));
        }
        if (this.editing == null && HighlightConfig.TrackedItem.values().length > 0) {
            this.editing = HighlightConfig.TrackedItem.values()[0];
        }
        this.loadHsvFromEntry(cfg.items.get((Object)this.editing));
        this.svX = panelLeft;
        this.svY = y;
        this.hueX = panelLeft;
        this.hueY = this.svY + this.svH + 8;
        this.alphaX = panelLeft;
        this.alphaY = this.hueY + this.hueH + 8;
        this.method_25411((class_339)new class_4185(panelLeft, this.alphaY + this.hueH + 24, 220, 20, (class_2561)new class_2585("\u0413\u043e\u0442\u043e\u0432\u043e"), btn -> this.method_25419()));
    }

    private static String toggleLabel(HighlightConfig.TrackedItem t, boolean enabled) {
        return t.label + ": " + (enabled ? "ON" : "OFF");
    }

    private String fitLabel(String text, int maxWidth) {
        String s = text;
        while (this.field_22793.method_1727(s) > maxWidth && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        if (!s.equals(text) && s.length() >= 1) {
            s = s.length() > 3 ? s.substring(0, s.length() - 3) + "..." : "...";
        }
        return s;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        matrices.method_22903();
        matrices.method_22905(0.9f, 0.9f, 1.0f);
        int titleX = (int)((float)(this.field_22789 / 2) / 0.9f) - this.field_22793.method_27525((class_5348)this.field_22785) / 2;
        HighlightConfigScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)titleX, (int)22, (int)0xFFFFFF);
        matrices.method_22909();
        if (this.editing != null) {
            this.drawSVSquare(matrices);
            this.drawHueBar(matrices);
            this.drawAlphaBar(matrices);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isIn(mouseX, mouseY, this.svX, this.svY, this.svW, this.svH)) {
            this.updateSVFromMouse(mouseX, mouseY);
            this.draggingSV = true;
            return true;
        }
        if (this.isIn(mouseX, mouseY, this.hueX, this.hueY, this.hueW, this.hueH)) {
            this.updateHueFromMouse(mouseX);
            this.draggingHue = true;
            return true;
        }
        if (this.isIn(mouseX, mouseY, this.alphaX, this.alphaY, this.alphaW, this.alphaH)) {
            this.updateAlphaFromMouse(mouseX);
            this.draggingAlpha = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingSV) {
            this.updateSVFromMouse(mouseX, mouseY);
            return true;
        }
        if (this.draggingHue) {
            this.updateHueFromMouse(mouseX);
            return true;
        }
        if (this.draggingAlpha) {
            this.updateAlphaFromMouse(mouseX);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingAlpha = false;
        this.draggingHue = false;
        this.draggingSV = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private void loadHsvFromEntry(HighlightConfig.Entry e) {
        int r = e.r & 0xFF;
        int g = e.g & 0xFF;
        int b = e.b & 0xFF;
        float[] hsv = HighlightConfigScreen.rgbToHsv(r, g, b);
        this.hue = hsv[0];
        this.sat = hsv[1];
        this.val = hsv[2];
        this.alpha = e.a & 0xFF;
    }

    private void pushHsvToEntry() {
        int rgb = HighlightConfigScreen.hsvToRgb(this.hue, this.sat, this.val);
        HighlightConfig.Entry e = HighlightConfig.get().items.get((Object)this.editing);
        e.r = rgb >> 16 & 0xFF;
        e.g = rgb >> 8 & 0xFF;
        e.b = rgb & 0xFF;
        e.a = this.alpha & 0xFF;
        HighlightConfig.save();
    }

    private void drawSVSquare(class_4587 matrices) {
        for (int x = 0; x < this.svW; ++x) {
            float s = HighlightConfigScreen.clamp01((float)x / (float)(this.svW - 1));
            int from = HighlightConfigScreen.hsvToRgb(this.hue, s, 1.0f);
            int to = HighlightConfigScreen.hsvToRgb(this.hue, s, 0.0f);
            int colFrom = 0xFF000000 | from;
            int colTo = 0xFF000000 | to;
            this.method_25296(matrices, this.svX + x, this.svY, this.svX + x + 1, this.svY + this.svH, colFrom, colTo);
        }
        int mx = (int)((float)this.svX + this.sat * (float)(this.svW - 1));
        int my = (int)((float)this.svY + (1.0f - this.val) * (float)(this.svH - 1));
        HighlightConfigScreen.method_25294((class_4587)matrices, (int)(mx - 2), (int)(my - 2), (int)(mx + 3), (int)(my + 3), (int)-1);
        HighlightConfigScreen.method_25294((class_4587)matrices, (int)(mx - 1), (int)(my - 1), (int)(mx + 2), (int)(my + 2), (int)-16777216);
    }

    private void drawHueBar(class_4587 matrices) {
        for (int x = 0; x < this.hueW; ++x) {
            float h = HighlightConfigScreen.clamp01((float)x / (float)(this.hueW - 1));
            int c = 0xFF000000 | HighlightConfigScreen.hsvToRgb(h, 1.0f, 1.0f);
            HighlightConfigScreen.method_25294((class_4587)matrices, (int)(this.hueX + x), (int)this.hueY, (int)(this.hueX + x + 1), (int)(this.hueY + this.hueH), (int)c);
        }
        int mx = (int)((float)this.hueX + this.hue * (float)(this.hueW - 1));
        HighlightConfigScreen.method_25294((class_4587)matrices, (int)(mx - 1), (int)(this.hueY - 2), (int)(mx + 2), (int)(this.hueY + this.hueH + 2), (int)-1);
    }

    private void drawAlphaBar(class_4587 matrices) {
        int x;
        int cell = 4;
        for (int y = 0; y < this.alphaH; y += cell) {
            for (x = 0; x < this.alphaW; x += cell) {
                boolean dark = (x / cell + y / cell) % 2 == 0;
                int bg = dark ? -4144960 : -1;
                HighlightConfigScreen.method_25294((class_4587)matrices, (int)(this.alphaX + x), (int)(this.alphaY + y), (int)(this.alphaX + x + cell), (int)(this.alphaY + y + cell), (int)bg);
            }
        }
        int rgb = HighlightConfigScreen.hsvToRgb(this.hue, this.sat, this.val) & 0xFFFFFF;
        for (x = 0; x < this.alphaW; ++x) {
            int a = (int)(HighlightConfigScreen.clamp01((float)x / (float)(this.alphaW - 1)) * 255.0f) & 0xFF;
            int c = a << 24 | rgb;
            HighlightConfigScreen.method_25294((class_4587)matrices, (int)(this.alphaX + x), (int)this.alphaY, (int)(this.alphaX + x + 1), (int)(this.alphaY + this.alphaH), (int)c);
        }
        int mx = (int)((float)this.alphaX + (float)this.alpha / 255.0f * (float)(this.alphaW - 1));
        HighlightConfigScreen.method_25294((class_4587)matrices, (int)(mx - 1), (int)(this.alphaY - 2), (int)(mx + 2), (int)(this.alphaY + this.alphaH + 2), (int)-16777216);
    }

    private boolean isIn(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && my >= (double)y && mx < (double)(x + w) && my < (double)(y + h);
    }

    private void updateSVFromMouse(double mx, double my) {
        this.sat = HighlightConfigScreen.clamp01((float)((mx - (double)this.svX) / (double)(this.svW - 1)));
        this.val = HighlightConfigScreen.clamp01(1.0f - (float)((my - (double)this.svY) / (double)(this.svH - 1)));
        this.pushHsvToEntry();
    }

    private void updateHueFromMouse(double mx) {
        this.hue = HighlightConfigScreen.clamp01((float)((mx - (double)this.hueX) / (double)(this.hueW - 1)));
        this.pushHsvToEntry();
    }

    private void updateAlphaFromMouse(double mx) {
        this.alpha = (int)(HighlightConfigScreen.clamp01((float)((mx - (double)this.alphaX) / (double)(this.alphaW - 1))) * 255.0f);
        this.pushHsvToEntry();
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static int hsvToRgb(float h, float s, float v) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = v;
            r = b;
        } else {
            h = (h % 1.0f + 1.0f) % 1.0f;
            float i = (float)Math.floor(h * 6.0f);
            float f = h * 6.0f - i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - f * s);
            float t = v * (1.0f - (1.0f - f) * s);
            int ii = (int)i % 6;
            switch (ii) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                default: {
                    r = v;
                    g = p;
                    b = q;
                }
            }
        }
        int R = (int)(r * 255.0f) & 0xFF;
        int G = (int)(g * 255.0f) & 0xFF;
        int B = (int)(b * 255.0f) & 0xFF;
        return R << 16 | G << 8 | B;
    }

    private static float[] rgbToHsv(int r, int g, int b) {
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float v = max;
        float d = max - min;
        float f = s = max == 0.0f ? 0.0f : d / max;
        float h = d == 0.0f ? 0.0f : (max == rf ? ((gf - bf) / d + (float)(gf < bf ? 6 : 0)) / 6.0f : (max == gf ? ((bf - rf) / d + 2.0f) / 6.0f : ((rf - gf) / d + 4.0f) / 6.0f));
        return new float[]{h, s, v};
    }

    private class ItemToggleButton
    extends class_4185 {
        private final HighlightConfig.TrackedItem item;

        public ItemToggleButton(int x, int y, int w, int h, HighlightConfig.TrackedItem item, class_2561 text, class_4185.class_4241 onPress) {
            super(x, y, w, h, text, onPress);
            this.item = item;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            boolean marquee = this.method_25367();
            class_2561 old = this.method_25369();
            if (marquee) {
                this.method_25355(class_2561.method_30163((String)""));
            }
            super.method_25359(matrices, mouseX, mouseY, delta);
            if (marquee) {
                this.method_25355(old);
            }
            int iconX = this.field_22760 + 4;
            int iconY = this.field_22761 + 2;
            HighlightConfigScreen.this.field_22788.method_27953(new class_1799((class_1935)this.item.item), iconX, iconY);
            if (marquee) {
                boolean enabledNow = HighlightConfig.get().items.get((Object)((Object)this.item)).enabled;
                String base = this.item.label + ": " + (enabledNow ? "ON" : "OFF");
                int startX = this.field_22760 + 22;
                int maxW = this.field_22758 - 26;
                int fullW = HighlightConfigScreen.this.field_22793.method_1727(base);
                if (fullW > maxW) {
                    int px;
                    int gap = 20;
                    int cycle = fullW + gap;
                    int offsetPx = px = (int)(System.currentTimeMillis() / 16L % (long)cycle);
                    int from = 0;
                    int acc = 0;
                    for (int i = 0; i < base.length(); ++i) {
                        int cw = HighlightConfigScreen.this.field_22793.method_1727(base.substring(i, i + 1));
                        if (acc + cw > offsetPx) {
                            from = i;
                            break;
                        }
                        acc += cw;
                    }
                    String sub = base.substring(from);
                    while (HighlightConfigScreen.this.field_22793.method_1727(sub) > maxW && sub.length() > 0) {
                        sub = sub.substring(0, sub.length() - 1);
                    }
                    ItemToggleButton.method_27535((class_4587)matrices, (class_327)HighlightConfigScreen.this.field_22793, (class_2561)new class_2585(sub), (int)startX, (int)(this.field_22761 + 6), (int)0xFFFFFF);
                } else {
                    ItemToggleButton.method_27535((class_4587)matrices, (class_327)HighlightConfigScreen.this.field_22793, (class_2561)new class_2585(base), (int)startX, (int)(this.field_22761 + 6), (int)0xFFFFFF);
                }
            }
        }
    }

    private static class ColorSlider
    extends class_357 {
        private final String label;
        private final ValueConsumer consumer;

        public ColorSlider(int x, int y, int width, int height, String label, int initial, ValueConsumer consumer) {
            super(x, y, width, height, (class_2561)new class_2585(""), Math.max(0.0, Math.min(1.0, (double)initial / 255.0)));
            this.label = label;
            this.consumer = consumer;
            this.method_25346();
        }

        protected void method_25346() {
            int value = (int)Math.round(this.field_22753 * 255.0);
            this.method_25355((class_2561)new class_2585(this.label + ": " + value));
        }

        protected void method_25344() {
            int value = (int)Math.round(this.field_22753 * 255.0);
            if (value < 0) {
                value = 0;
            }
            if (value > 255) {
                value = 255;
            }
            this.consumer.accept(value);
        }

        static interface ValueConsumer {
            public void accept(int var1);
        }
    }
}

