/*
 * Decompiled with CFR 0.152.
 */
package ru.powerlands.highlightitems.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public class HighlightConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Root state = new Root();

    public static Root get() {
        return state;
    }

    public static void ensureDefaults() {
        for (TrackedItem t : TrackedItem.values()) {
            Entry e = HighlightConfig.state.items.computeIfAbsent(t, k -> new Entry());
            if (e.r < 0) {
                e.r = HighlightConfig.state.colorR;
            }
            if (e.g < 0) {
                e.g = HighlightConfig.state.colorG;
            }
            if (e.b < 0) {
                e.b = HighlightConfig.state.colorB;
            }
            if (e.a >= 0) continue;
            e.a = HighlightConfig.state.alpha;
        }
    }

    public static File getConfigFile() {
        File dir = new File("config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, "TopkaItemColor.json");
    }

    public static void load() {
        File file = HighlightConfig.getConfigFile();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Root loaded = (Root)GSON.fromJson((Reader)reader, Root.class);
                if (loaded != null) {
                    state = loaded;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HighlightConfig.ensureDefaults();
        HighlightConfig.save();
    }

    public static void save() {
        HighlightConfig.ensureDefaults();
        File file = HighlightConfig.getConfigFile();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)state, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Root {
        public Map<TrackedItem, Entry> items = new EnumMap<TrackedItem, Entry>(TrackedItem.class);
        public int colorR = 0;
        public int colorG = 255;
        public int colorB = 0;
        public int alpha = 96;
    }

    public static class Entry {
        public boolean enabled = true;
        public int r = -1;
        public int g = -1;
        public int b = -1;
        public int a = -1;
    }

    public static enum TrackedItem {
        ENDER_EYE(class_1802.field_8449, " \u0414\u0435\u0437\u043e\u0440\u0438\u043d\u0442\u0430\u0446\u0438\u044f"),
        FIRE_CHARGE(class_1802.field_8814, "\u041e\u0433\u043d\u0435\u043d\u044b\u0439 \u0441\u043c\u0435\u0440\u0447 / \u0412\u0437\u0440\u044b\u0432\u043d\u0430\u044f \u0448\u0442\u0443\u0447\u043a\u0430"),
        SUGAR(class_1802.field_8479, " \u042f\u0432\u043d\u0430\u044f \u043f\u044b\u043b\u044c"),
        Totem_of_Undying(class_1802.field_8288, "\u0422\u043e\u0442\u0435\u043c \u0431\u0435\u0441\u043c\u0435\u0440\u0442\u0438\u044f"),
        EXPERIENCE_BOTTLE(class_1802.field_8287, "\u0411\u0443\u0442\u044b\u043b\u043a\u0430 \u043e\u043f\u044b\u0442\u0430"),
        NETHERITE_SCRAP(class_1802.field_22021, "\u0422\u0440\u0430\u043f\u043a\u0430"),
        DRIED_KELP(class_1802.field_8551, "\u041f\u043b\u0430\u0441\u0442"),
        golden_apple(class_1802.field_8463, "\u0417\u043e\u043b\u043e\u0442\u0430\u044f \u044f\u0431\u043b\u043e\u043a\u043e"),
        enchanted_golden_apple(class_1802.field_8367, "\u0417\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0437\u043e\u043b\u043e\u0442\u043e\u0435 \u044f\u0431\u043b\u043e\u043a\u043e"),
        CHORUS_FRUIT(class_1802.field_8233, "\u0425\u043e\u0440\u0443\u0441"),
        ENDER_PEARL(class_1802.field_8634, "\u042d\u043d\u0434\u0435\u0440 \u041f\u0451\u0440\u043b"),
        SNOWBALL(class_1802.field_8543, "\u0421\u043d\u0435\u0436\u043e\u043a \u0437\u0430\u043c\u043e\u0440\u043e\u0437\u043a\u0430/\u041a\u043e\u043c \u0441\u043d\u0435\u0433\u0430"),
        POPPED_CHORUS_FRUIT(class_1802.field_8882, "\u0422\u0440\u0430\u043f\u043a\u0430"),
        NETHER_STAR(class_1802.field_8137, "\u0421\u0442\u0430\u043d"),
        JACK_O_LANTERN(class_1802.field_8693, "\u0421\u0432\u0435\u0442\u0438\u043b\u044c\u043d\u0438\u043a \u0414\u0436\u0435\u0439\u043a\u0430"),
        PRISMARINE_SHARD(class_1802.field_8662, "\u0412\u0437\u0440\u044b\u0432\u043d\u0430\u044f \u0422\u0440\u0430\u043f\u043a\u0430");

        public final class_1792 item;
        public final String label;

        private TrackedItem(class_1792 item, String label) {
            this.item = item;
            this.label = label;
        }
    }
}

