/*
 * Decompiled with CFR 0.152.
 */
package com.topkatraptracker.trap;

import com.topkatraptracker.trap.TrapCountdown;
import com.topkatraptracker.trap.TrapState;
import com.topkatraptracker.trap.TrapType;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TrapBossbarManager {
    private static final TrapBossbarManager INSTANCE = new TrapBossbarManager();
    private static final int BAR_SEGMENTS = 10;
    private static final int STRUCTURE_CHECK_DELAY_TICKS = 3;
    private static final int RIGHT_CLICK_TIMEOUT_TICKS = 10;
    private final class_310 minecraft = class_310.method_1551();
    private TrapCountdown activeCountdown;
    private int previousScrapCount = -1;
    private int previousPrismarineCount = -1;
    private int previousChorusCount = -1;
    private int structureCheckDelay = 0;
    private boolean rightClickedWithItem = false;
    private int itemCountBeforeRightClick = -1;
    private int rightClickTimeout = 0;
    private TrapType pendingTrapType = null;

    public static TrapBossbarManager getInstance() {
        return INSTANCE;
    }

    public void handleRightClick() {
        if (!TrapState.isEnabled()) {
            return;
        }
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (this.isHoldingPrismarine(player)) {
            this.itemCountBeforeRightClick = this.countPrismarine(player);
            this.rightClickedWithItem = true;
            this.rightClickTimeout = 10;
            this.pendingTrapType = TrapType.EXPLOSIVE;
            return;
        }
        if (this.isHoldingChorus(player)) {
            this.itemCountBeforeRightClick = this.countChorus(player);
            this.rightClickedWithItem = true;
            this.rightClickTimeout = 10;
            this.pendingTrapType = TrapType.HOLYWORLD;
            return;
        }
        if (this.isHoldingScrap(player)) {
            this.itemCountBeforeRightClick = this.countScrap(player);
            this.rightClickedWithItem = true;
            this.rightClickTimeout = 10;
            this.pendingTrapType = null;
        } else {
            this.rightClickedWithItem = false;
            this.itemCountBeforeRightClick = -1;
            this.rightClickTimeout = 0;
            this.pendingTrapType = null;
        }
    }

    public void clientTick() {
        if (!TrapState.isEnabled()) {
            this.reset();
            return;
        }
        class_746 player = this.minecraft.field_1724;
        class_638 world = this.minecraft.field_1687;
        if (player == null || world == null) {
            this.reset();
            return;
        }
        int totalScrap = this.countScrap(player);
        int totalPrismarine = this.countPrismarine(player);
        int totalChorus = this.countChorus(player);
        if (this.previousScrapCount == -1) {
            this.previousScrapCount = totalScrap;
        }
        if (this.previousPrismarineCount == -1) {
            this.previousPrismarineCount = totalPrismarine;
        }
        if (this.previousChorusCount == -1) {
            this.previousChorusCount = totalChorus;
        }
        if (this.rightClickTimeout > 0) {
            --this.rightClickTimeout;
            if (this.rightClickTimeout == 0) {
                this.rightClickedWithItem = false;
                this.itemCountBeforeRightClick = -1;
                this.pendingTrapType = null;
            }
        }
        if (this.rightClickedWithItem && this.itemCountBeforeRightClick >= 0) {
            boolean itemUsed = false;
            if (this.pendingTrapType == TrapType.EXPLOSIVE && totalPrismarine < this.previousPrismarineCount) {
                itemUsed = true;
            } else if (this.pendingTrapType == TrapType.HOLYWORLD && totalChorus < this.previousChorusCount) {
                itemUsed = true;
            } else if (this.pendingTrapType == null && totalScrap < this.itemCountBeforeRightClick) {
                itemUsed = true;
            }
            if (itemUsed) {
                if (this.pendingTrapType != null && this.pendingTrapType != TrapType.NORMAL && this.pendingTrapType != TrapType.DRAGON) {
                    this.startCountdown(this.pendingTrapType);
                } else {
                    this.structureCheckDelay = 3;
                }
                this.rightClickedWithItem = false;
                this.itemCountBeforeRightClick = -1;
                this.rightClickTimeout = 0;
                this.pendingTrapType = null;
            }
        }
        if (this.structureCheckDelay > 0) {
            --this.structureCheckDelay;
            if (this.structureCheckDelay == 0) {
                TrapType trapType = this.detectTrapStructure(player, world);
                this.startCountdown(trapType == null ? TrapType.NORMAL : trapType);
            }
        }
        this.previousScrapCount = totalScrap;
        this.previousPrismarineCount = totalPrismarine;
        this.previousChorusCount = totalChorus;
        if (this.activeCountdown != null) {
            this.sendActionBar(player);
            if (this.activeCountdown.isFinished()) {
                this.activeCountdown = null;
            }
        }
    }

    private void reset() {
        this.previousScrapCount = -1;
        this.previousPrismarineCount = -1;
        this.previousChorusCount = -1;
        this.structureCheckDelay = 0;
        this.activeCountdown = null;
        this.rightClickedWithItem = false;
        this.itemCountBeforeRightClick = -1;
        this.rightClickTimeout = 0;
        this.pendingTrapType = null;
    }

    private void startCountdown(TrapType type) {
        this.activeCountdown = new TrapCountdown(type);
    }

    private void sendActionBar(class_746 player) {
        if (player == null || this.activeCountdown == null) {
            return;
        }
        try {
            String displayText = this.activeCountdown.getDisplayText();
            String progressBar = this.buildProgressBar(this.activeCountdown.getProgress());
            class_2585 message = new class_2585(displayText + " " + progressBar);
            player.method_7353((class_2561)message, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildProgressBar(float progress) {
        int i;
        class_124 fillColor;
        if (this.activeCountdown == null) {
            return "";
        }
        int filled = class_3532.method_15375((float)(progress * 10.0f));
        int empty = 10 - filled;
        StringBuilder builder = new StringBuilder(50);
        builder.append(class_124.field_1063).append("\u258c");
        switch (this.activeCountdown.getType()) {
            case DRAGON: {
                fillColor = class_124.field_1076;
                break;
            }
            case EXPLOSIVE: {
                fillColor = class_124.field_1078;
                break;
            }
            case HOLYWORLD: {
                fillColor = class_124.field_1064;
                break;
            }
            default: {
                fillColor = class_124.field_1060;
            }
        }
        builder.append(fillColor);
        for (i = 0; i < filled; ++i) {
            builder.append("\u2588");
        }
        builder.append(class_124.field_1063);
        for (i = 0; i < empty; ++i) {
            builder.append("\u2591");
        }
        builder.append("\u258c").append(class_124.field_1070);
        return builder.toString();
    }

    private boolean isHoldingScrap(class_746 player) {
        if (player == null) {
            return false;
        }
        try {
            class_1792 mainHand = player.method_6047().method_7909();
            class_1792 offHand = player.method_6079().method_7909();
            return mainHand == class_1802.field_22021 || offHand == class_1802.field_22021;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isHoldingPrismarine(class_746 player) {
        if (player == null) {
            return false;
        }
        try {
            class_1792 mainHand = player.method_6047().method_7909();
            class_1792 offHand = player.method_6079().method_7909();
            return mainHand == class_1802.field_8662 || offHand == class_1802.field_8662;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isHoldingChorus(class_746 player) {
        if (player == null) {
            return false;
        }
        try {
            class_1792 mainHand = player.method_6047().method_7909();
            class_1792 offHand = player.method_6079().method_7909();
            return mainHand == class_1802.field_8882 || offHand == class_1802.field_8882;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int countScrap(class_746 player) {
        return this.countItem(player, class_1802.field_22021);
    }

    private int countPrismarine(class_746 player) {
        return this.countItem(player, class_1802.field_8662);
    }

    private int countChorus(class_746 player) {
        return this.countItem(player, class_1802.field_8882);
    }

    private int countItem(class_746 player, class_1792 targetItem) {
        if (player == null || player.field_7514 == null) {
            return 0;
        }
        try {
            int total = 0;
            if (player.field_7514.field_7547 != null) {
                total += this.countItemInList((List<class_1799>)player.field_7514.field_7547, targetItem);
            }
            if (player.field_7514.field_7544 != null) {
                total += this.countItemInList((List<class_1799>)player.field_7514.field_7544, targetItem);
            }
            return total;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int countItemInList(List<class_1799> stacks, class_1792 targetItem) {
        if (stacks == null) {
            return 0;
        }
        int total = 0;
        for (class_1799 stack : stacks) {
            if (stack == null || stack.method_7960() || stack.method_7909() != targetItem) continue;
            total += stack.method_7947();
        }
        return total;
    }

    private TrapType detectTrapStructure(class_746 player, class_638 world) {
        if (player == null || world == null) {
            return TrapType.NORMAL;
        }
        try {
            class_2338 playerPos = player.method_24515();
            if (this.isDragonTrapStructure(world, playerPos)) {
                return TrapType.DRAGON;
            }
            return TrapType.NORMAL;
        }
        catch (Exception e) {
            return TrapType.NORMAL;
        }
    }

    private boolean isDragonTrapStructure(class_638 world, class_2338 center) {
        int halfSize = 3;
        int netheriteCount = 0;
        int totalBlocks = 0;
        for (int x = -halfSize; x <= halfSize; ++x) {
            for (int y = -halfSize; y <= halfSize; ++y) {
                for (int z = -halfSize; z <= halfSize; ++z) {
                    class_2338 checkPos = center.method_10069(x, y, z);
                    if (world.method_8320(checkPos).method_26204() == class_2246.field_10124) continue;
                    ++totalBlocks;
                    if (world.method_8320(checkPos).method_26204() == class_2246.field_22108) {
                        ++netheriteCount;
                    }
                    if (totalBlocks < 50 || netheriteCount < 1) continue;
                    return true;
                }
            }
        }
        return totalBlocks >= 50 && netheriteCount >= 1;
    }
}

