/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.inactive_navigations;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import me.jellysquid.mods.lithium.common.entity.EntityNavigationExtended;
import me.jellysquid.mods.lithium.common.world.ServerWorldExtended;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin
extends class_1937
implements ServerWorldExtended {
    @Mutable
    @Shadow
    @Final
    private Set<class_1408> field_18262;
    private ReferenceOpenHashSet<class_1408> activeEntityNavigations;
    private ArrayList<class_1408> activeEntityNavigationUpdates;
    private boolean isIteratingActiveEntityNavigations;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> registryKey, class_2874 dimensionType, class_3949 worldGenerationProgressListener, class_2794 chunkGenerator, boolean debugWorld, long l, List<class_5304> list, boolean bl, CallbackInfo ci) {
        this.field_18262 = new ReferenceOpenHashSet(this.field_18262);
        this.activeEntityNavigations = new ReferenceOpenHashSet();
        this.activeEntityNavigationUpdates = new ArrayList();
        this.isIteratingActiveEntityNavigations = false;
    }

    @Redirect(method={"loadEntityUnchecked"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/mob/MobEntity;getNavigation()Lnet/minecraft/entity/ai/pathing/EntityNavigation;"))
    private class_1408 startListeningOnEntityLoad(class_1308 mobEntity) {
        class_1408 navigation = mobEntity.method_5942();
        ((EntityNavigationExtended)navigation).setRegisteredToWorld(true);
        if (navigation.method_6345() != null) {
            this.activeEntityNavigations.add((Object)navigation);
        }
        return navigation;
    }

    @Redirect(method={"unloadEntity"}, at=@At(value="INVOKE", target="Ljava/util/Set;remove(Ljava/lang/Object;)Z"))
    private boolean stopListeningOnEntityUnload(Set<class_1408> set, Object navigation) {
        class_1408 entityNavigation = (class_1408)navigation;
        ((EntityNavigationExtended)entityNavigation).setRegisteredToWorld(false);
        this.activeEntityNavigations.remove((Object)entityNavigation);
        return set.remove(entityNavigation);
    }

    @Redirect(method={"updateListeners"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;"))
    private Iterator<class_1408> getActiveListeners(Set<class_1408> set) {
        this.isIteratingActiveEntityNavigations = true;
        return this.activeEntityNavigations.iterator();
    }

    @Inject(method={"updateListeners"}, at={@At(value="RETURN")})
    private void onIterationFinished(class_2338 pos, class_2680 oldState, class_2680 newState, int flags, CallbackInfo ci) {
        this.isIteratingActiveEntityNavigations = false;
        if (!this.activeEntityNavigationUpdates.isEmpty()) {
            this.applyActiveEntityNavigationUpdates();
        }
    }

    private void applyActiveEntityNavigationUpdates() {
        ArrayList<class_1408> entityNavigationsUpdates = this.activeEntityNavigationUpdates;
        for (int i = entityNavigationsUpdates.size() - 1; i >= 0; --i) {
            class_1408 entityNavigation = entityNavigationsUpdates.remove(i);
            if (entityNavigation.method_6345() != null && ((EntityNavigationExtended)entityNavigation).isRegisteredToWorld()) {
                this.activeEntityNavigations.add((Object)entityNavigation);
                continue;
            }
            this.activeEntityNavigations.remove((Object)entityNavigation);
        }
    }

    @Override
    public void setNavigationActive(Object entityNavigation) {
        class_1408 entityNavigation1 = (class_1408)entityNavigation;
        if (!this.isIteratingActiveEntityNavigations) {
            this.activeEntityNavigations.add((Object)entityNavigation1);
        } else {
            this.activeEntityNavigationUpdates.add(entityNavigation1);
        }
    }

    @Override
    public void setNavigationInactive(Object entityNavigation) {
        class_1408 entityNavigation1 = (class_1408)entityNavigation;
        if (!this.isIteratingActiveEntityNavigations) {
            this.activeEntityNavigations.remove((Object)entityNavigation1);
        } else {
            this.activeEntityNavigationUpdates.add(entityNavigation1);
        }
    }

    protected ServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_2874 dimensionType, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long seed) {
        super(properties, registryRef, dimensionType, profiler, isClient, debugWorld, seed);
    }

    public boolean isConsistent() {
        int i = 0;
        for (class_1408 entityNavigation : this.field_18262) {
            if ((entityNavigation.method_6345() != null && ((EntityNavigationExtended)entityNavigation).isRegisteredToWorld()) != this.activeEntityNavigations.contains((Object)entityNavigation)) {
                return false;
            }
            if (entityNavigation.method_6345() == null) continue;
            ++i;
        }
        return this.activeEntityNavigations.size() == i;
    }
}

