/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5224;
import net.minecraft.class_5481;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;

public class TooltipOverlayHandler {
    public static TooltipOverlayHandler INSTANCE;
    private static class_2960 modIcons;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_BOTTOM = 3;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_TOP = -3;
    public static final int TOOLTIP_REAL_WIDTH_OFFSET_RIGHT = 3;
    private static final TextureOffsets normalBarTextureOffsets;
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        INSTANCE = new TooltipOverlayHandler();
    }

    public void onItemTooltip(class_1799 hoveredStack, class_1657 player, class_1836 context, List tooltip) {
        if (hoveredStack == null || tooltip == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (!this.shouldShowTooltip(hoveredStack)) {
            return;
        }
        FoodValues defaultFood = FoodHelper.getDefaultFoodValues(hoveredStack);
        FoodValues modifiedFood = FoodHelper.getModifiedFoodValues(hoveredStack, player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent(player, hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact(foodValuesEvent);
        defaultFood = foodValuesEvent.defaultFoodValues;
        modifiedFood = foodValuesEvent.modifiedFoodValues;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Pre.EVENT.invoker()).interact(prerenderEvent);
        if (prerenderEvent.isCanceled) {
            return;
        }
        FoodOverlay foodOverlay = new FoodOverlay(prerenderEvent.itemStack, defaultFood, modifiedFood, player);
        if (foodOverlay.shouldRenderHungerBars()) {
            class_2583 style = class_2583.field_24360.method_27704((class_2960)new FoodOverlayFont(foodOverlay));
            class_2585 placeholder = new class_2585(foodOverlay.getTooltip());
            tooltip.add(placeholder.method_10862(style));
            tooltip.add(placeholder.method_10862(style));
        }
    }

    public void onRenderTooltip(class_4587 matrixStack, List<? extends class_5481> tooltip, int toolTipX, int toolTipY, int toolTipW, int toolTipH) {
        if (matrixStack == null || tooltip == null || ModConfig.INSTANCE == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_437 gui = mc.field_1755;
        if (gui == null) {
            return;
        }
        FoodOverlay foodOverlay = null;
        for (int i = 0; i < tooltip.size(); ++i) {
            foodOverlay = FoodOverlayFont.getFoodOverlay(tooltip.get(i));
            if (foodOverlay == null) continue;
            toolTipY += i * 10;
            break;
        }
        if (foodOverlay == null) {
            return;
        }
        class_1799 itemStack = foodOverlay.itemStack;
        FoodValues defaultFood = foodOverlay.defaultFood;
        FoodValues modifiedFood = foodOverlay.modifiedFood;
        int x = toolTipX;
        int y = toolTipY + 2;
        TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, x, y, matrixStack, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Render.EVENT.invoker()).interact(renderEvent);
        if (renderEvent.isCanceled) {
            return;
        }
        x = renderEvent.x;
        y = renderEvent.y;
        itemStack = renderEvent.itemStack;
        matrixStack = renderEvent.matrixStack;
        int defaultFoodHunger = defaultFood.hunger;
        int modifiedFoodHunger = modifiedFood.hunger;
        RenderSystem.disableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        x += (foodOverlay.hungerBars - 1) * 9;
        mc.method_1531().method_22813(class_437.field_22737);
        TextureOffsets offsets = FoodHelper.isRotten(itemStack) ? rottenBarTextureOffsets : normalBarTextureOffsets;
        for (int i = 0; i < foodOverlay.hungerBars * 2; i += 2) {
            if (modifiedFoodHunger < 0) {
                gui.method_25302(matrixStack, x, y, offsets.containerNegativeHunger, 27, 9, 9);
            } else if (modifiedFoodHunger > defaultFoodHunger && defaultFoodHunger <= i) {
                gui.method_25302(matrixStack, x, y, offsets.containerExtraHunger, 27, 9, 9);
            } else if (modifiedFoodHunger > i + 1 || defaultFoodHunger == modifiedFoodHunger) {
                gui.method_25302(matrixStack, x, y, offsets.containerNormalHunger, 27, 9, 9);
            } else if (modifiedFoodHunger == i + 1) {
                gui.method_25302(matrixStack, x, y, offsets.containerPartialHunger, 27, 9, 9);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                gui.method_25302(matrixStack, x, y, offsets.containerMissingHunger, 27, 9, 9);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            gui.method_25302(matrixStack, x, y, defaultFoodHunger - 1 == i ? offsets.shankMissingPartial : offsets.shankMissingFull, 27, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (modifiedFoodHunger > i) {
                gui.method_25302(matrixStack, x, y, modifiedFoodHunger - 1 == i ? offsets.shankPartial : offsets.shankFull, 27, 9, 9);
            }
            x -= 9;
        }
        if (foodOverlay.hungerBarsText != null) {
            matrixStack.method_22903();
            matrixStack.method_22904((double)(x += 18), (double)y, 0.0);
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
            mc.field_1772.method_1720(matrixStack, foodOverlay.hungerBarsText, 2.0f, 2.0f, -5592406);
            matrixStack.method_22909();
        }
        x = toolTipX;
        y += 10;
        float modifiedSaturationIncrement = modifiedFood.getSaturationIncrement();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        x += (foodOverlay.saturationBars - 1) * 7;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.method_1531().method_22813(modIcons);
        for (int i = 0; i < foodOverlay.saturationBars * 2; i += 2) {
            boolean shouldBeFaded;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            if (shouldBeFaded) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            gui.method_25302(matrixStack, x, y, effectiveSaturationOfBar >= 1.0f ? 21 : ((double)effectiveSaturationOfBar > 0.5 ? 14 : ((double)effectiveSaturationOfBar > 0.25 ? 7 : (effectiveSaturationOfBar > 0.0f ? 0 : 28))), modifiedSaturationIncrement >= 0.0f ? 27 : 34, 7, 7);
            if (shouldBeFaded) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            x -= 7;
        }
        if (foodOverlay.saturationBarsText != null) {
            matrixStack.method_22903();
            matrixStack.method_22904((double)(x += 14), (double)y, 0.0);
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
            mc.field_1772.method_1720(matrixStack, foodOverlay.saturationBarsText, 2.0f, 1.0f, -5592406);
            matrixStack.method_22909();
        }
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
    }

    private boolean shouldShowTooltip(class_1799 hoveredStack) {
        boolean shouldShowTooltip;
        if (hoveredStack.method_7960()) {
            return false;
        }
        boolean bl = shouldShowTooltip = ModConfig.INSTANCE.showFoodValuesInTooltip && KeyHelper.isShiftKeyDown() || ModConfig.INSTANCE.showFoodValuesInTooltipAlways;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack);
    }

    static {
        modIcons = new class_2960("appleskin", "textures/icons.png");
        normalBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 16;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    static class FoodOverlay {
        private FoodValues defaultFood;
        private FoodValues modifiedFood;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private String tooltip;
        private class_1799 itemStack;

        FoodOverlay(class_1799 itemStack, FoodValues defaultFood, FoodValues modifiedFood, class_1657 player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.biggestHunger = Math.max(defaultFood.hunger, modifiedFood.hunger);
            this.biggestSaturationIncrement = Math.max(defaultFood.getSaturationIncrement(), modifiedFood.getSaturationIncrement());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        String getTooltip() {
            if (this.tooltip != null) {
                return this.tooltip;
            }
            float scale = 2.2f;
            float hungerBarsLength = (float)this.hungerBars * scale;
            if (this.hungerBarsText != null) {
                hungerBarsLength += (float)this.hungerBarsText.length();
            }
            float saturationBarsLength = (float)this.saturationBars * scale;
            if (this.saturationBarsText != null) {
                saturationBarsLength += (float)this.saturationBarsText.length();
            }
            int length = (int)Math.ceil(Math.max(hungerBarsLength, saturationBarsLength * 0.8f));
            StringBuilder s = new StringBuilder(" ");
            for (int i = 0; i < length; ++i) {
                s.append(" ");
            }
            this.tooltip = s.toString();
            return this.tooltip;
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }

        boolean shouldRenderSaturationBars() {
            return this.saturationBars > 0;
        }
    }

    static class FoodOverlayFont
    extends class_2960 {
        private FoodOverlay foodOverlay;

        FoodOverlayFont(FoodOverlay foodOverlay) {
            super(class_2583.field_24359.method_12836(), class_2583.field_24359.method_12832());
            this.foodOverlay = foodOverlay;
        }

        static Object getFontId(class_5481 line) {
            final Object[] fontId = new Object[]{class_2583.field_24359};
            line.accept(new class_5224(){

                public boolean accept(int index, class_2583 style, int codePoint) {
                    fontId[0] = style.method_27708();
                    return false;
                }
            });
            return fontId[0];
        }

        static FoodOverlay getFoodOverlay(class_5481 line) {
            Object fontId = FoodOverlayFont.getFontId(line);
            if (fontId instanceof FoodOverlayFont) {
                return ((FoodOverlayFont)((Object)fontId)).foodOverlay;
            }
            return null;
        }
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }
}

