/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PalettedContainerExtended;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPaletteFallback;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalleteArray;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2816;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_3341;
import net.minecraft.class_3508;
import net.minecraft.class_4076;
import net.minecraft.class_4548;

public class ClonedChunkSection {
    private static final class_1944[] LIGHT_TYPES = class_1944.values();
    private static final class_2826 EMPTY_SECTION = new class_2826(0);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final ClonedChunkSectionCache backingCache;
    private final Long2ObjectOpenHashMap<class_2586> blockEntities;
    private final class_2804[] lightDataArrays;
    private final class_1937 world;
    private class_4076 pos;
    private class_3508 blockStateData;
    private ClonedPalette<class_2680> blockStatePalette;
    private class_4548 biomeData;

    ClonedChunkSection(ClonedChunkSectionCache backingCache, class_1937 world) {
        this.backingCache = backingCache;
        this.world = world;
        this.blockEntities = new Long2ObjectOpenHashMap(8);
        this.lightDataArrays = new class_2804[LIGHT_TYPES.length];
    }

    public void init(class_4076 pos) {
        class_2818 chunk = this.world.method_8497(pos.method_10263(), pos.method_10260());
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + pos.method_18692());
        }
        class_2826 section = ClonedChunkSection.getChunkSection((class_2791)chunk, pos);
        if (class_2826.method_18090((class_2826)section)) {
            section = EMPTY_SECTION;
        }
        this.pos = pos;
        PalettedContainerExtended<class_2680> container = PalettedContainerExtended.cast(section.method_12265());
        this.blockStateData = ClonedChunkSection.copyBlockData(container);
        this.blockStatePalette = ClonedChunkSection.copyPalette(container);
        for (class_1944 type : LIGHT_TYPES) {
            this.lightDataArrays[type.ordinal()] = this.world.method_22336().method_15562(type).method_15544(pos);
        }
        this.biomeData = chunk.method_12036();
        class_3341 box = new class_3341(pos.method_19527(), pos.method_19528(), pos.method_19529(), pos.method_19530(), pos.method_19531(), pos.method_19532());
        this.blockEntities.clear();
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            class_2338 entityPos = (class_2338)entry.getKey();
            if (!box.method_14662((class_2382)entityPos)) continue;
            this.blockEntities.put(class_2338.method_10064((int)(entityPos.method_10263() & 0xF), (int)(entityPos.method_10264() & 0xF), (int)(entityPos.method_10260() & 0xF)), entry.getValue());
        }
    }

    public class_2680 getBlockState(int x, int y, int z) {
        return this.blockStatePalette.get(this.blockStateData.method_15211(y << 8 | z << 4 | x));
    }

    public int getLightLevel(class_1944 type, int x, int y, int z) {
        class_2804 array = this.lightDataArrays[type.ordinal()];
        if (array != null) {
            return array.method_12139(x, y, z);
        }
        return 0;
    }

    public class_1959 getBiomeForNoiseGen(int x, int y, int z) {
        return this.biomeData.method_16359(x, y, z);
    }

    public class_2586 getBlockEntity(int x, int y, int z) {
        return (class_2586)this.blockEntities.get(class_2338.method_10064((int)x, (int)y, (int)z));
    }

    public class_3508 getBlockData() {
        return this.blockStateData;
    }

    public ClonedPalette<class_2680> getBlockPalette() {
        return this.blockStatePalette;
    }

    public class_4076 getPosition() {
        return this.pos;
    }

    private static ClonedPalette<class_2680> copyPalette(PalettedContainerExtended<class_2680> container) {
        class_2837<class_2680> palette = container.getPalette();
        if (palette instanceof class_2816) {
            return new ClonedPaletteFallback<class_2680>(class_2248.field_10651);
        }
        class_2680[] array = new class_2680[1 << container.getPaletteSize()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (class_2680)palette.method_12288(i);
            if (array[i] == null) break;
        }
        return new ClonedPalleteArray<class_2680>(array, container.getDefaultValue());
    }

    private static class_3508 copyBlockData(PalettedContainerExtended<class_2680> container) {
        class_3508 array = container.getDataArray();
        long[] storage = array.method_15212();
        return new class_3508(container.getPaletteSize(), array.method_15215(), (long[])storage.clone());
    }

    private static class_2826 getChunkSection(class_2791 chunk, class_4076 pos) {
        class_2826 section = null;
        if (!class_1937.method_8476((int)class_4076.method_18688((int)pos.method_10264()))) {
            section = chunk.method_12006()[pos.method_10264()];
        }
        return section;
    }

    public void acquireReference() {
        this.referenceCount.incrementAndGet();
    }

    public boolean releaseReference() {
        return this.referenceCount.decrementAndGet() <= 0;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }
}

