/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import java.lang.reflect.Field;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import sun.misc.Unsafe;

public class UnsafeUtil {
    private static final boolean SUPPORTED;
    private static boolean AVAILABLE;
    private static final Unsafe UNSAFE;
    public static final long INT_ARRAY_OFFSET;

    private static Unsafe findUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            SodiumClientMod.logger().warn("Could not find Unsafe intrinsics", (Throwable)e);
            return null;
        }
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static Unsafe instance() {
        if (!UnsafeUtil.isAvailable()) {
            throw new UnsupportedOperationException("Unsafe intrinsics are not available");
        }
        return UNSAFE;
    }

    public static Unsafe instanceNullable() {
        return UNSAFE;
    }

    public static void setEnabled(boolean enabled) {
        AVAILABLE = UnsafeUtil.isSupported() && enabled;
    }

    static {
        UNSAFE = UnsafeUtil.findUnsafe();
        SUPPORTED = UNSAFE != null;
        INT_ARRAY_OFFSET = SUPPORTED ? (long)UNSAFE.arrayBaseOffset(int[].class) : -1L;
        UnsafeUtil.setEnabled(true);
    }
}

