/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.compat.LegacyFogHelper;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderBindingPoints;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public abstract class ChunkRenderShaderBackend<T extends ChunkGraphicsState>
implements ChunkRenderBackend<T> {
    private final EnumMap<ChunkFogMode, ChunkProgram> programs = new EnumMap(ChunkFogMode.class);
    protected final ChunkVertexType vertexType;
    protected final GlVertexFormat<ChunkMeshAttribute> vertexFormat;
    protected ChunkProgram activeProgram;

    public ChunkRenderShaderBackend(ChunkVertexType vertexType) {
        this.vertexType = vertexType;
        this.vertexFormat = vertexType.getCustomVertexFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkProgram createShader(RenderDevice device, ChunkFogMode fogMode, GlVertexFormat<ChunkMeshAttribute> vertexFormat) {
        GlShader vertShader = ShaderLoader.loadShader(device, ShaderType.VERTEX, new class_2960("sodium", "chunk_gl20.v.glsl"), fogMode.getDefines());
        GlShader fragShader = ShaderLoader.loadShader(device, ShaderType.FRAGMENT, new class_2960("sodium", "chunk_gl20.f.glsl"), fogMode.getDefines());
        try {
            ChunkProgram chunkProgram = GlProgram.builder(new class_2960("sodium", "chunk_shader")).attachShader(vertShader).attachShader(fragShader).bindAttribute("a_Pos", ChunkShaderBindingPoints.POSITION).bindAttribute("a_Color", ChunkShaderBindingPoints.COLOR).bindAttribute("a_TexCoord", ChunkShaderBindingPoints.TEX_COORD).bindAttribute("a_LightCoord", ChunkShaderBindingPoints.LIGHT_COORD).bindAttribute("d_ModelOffset", ChunkShaderBindingPoints.MODEL_OFFSET).build((program, name) -> new ChunkProgram(device, program, name, fogMode.getFactory()));
            return chunkProgram;
        }
        finally {
            vertShader.delete();
            fragShader.delete();
        }
    }

    @Override
    public final void createShaders(RenderDevice device) {
        this.programs.put(ChunkFogMode.NONE, this.createShader(device, ChunkFogMode.NONE, this.vertexFormat));
        this.programs.put(ChunkFogMode.LINEAR, this.createShader(device, ChunkFogMode.LINEAR, this.vertexFormat));
        this.programs.put(ChunkFogMode.EXP2, this.createShader(device, ChunkFogMode.EXP2, this.vertexFormat));
    }

    @Override
    public void begin(class_4587 matrixStack) {
        this.activeProgram = this.programs.get((Object)LegacyFogHelper.getFogMode());
        this.activeProgram.bind();
        this.activeProgram.setup(matrixStack, this.vertexType.getModelScale(), this.vertexType.getTextureScale());
    }

    @Override
    public void end(class_4587 matrixStack) {
        this.activeProgram.unbind();
        this.activeProgram = null;
    }

    @Override
    public void delete() {
        for (ChunkProgram shader : this.programs.values()) {
            shader.delete();
        }
    }

    @Override
    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }
}

