/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.cull.graph;

import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_854;

public class ChunkGraphNode {
    private static final long DEFAULT_VISIBILITY_DATA = ChunkGraphNode.calculateVisibilityData(ChunkRenderData.EMPTY.getOcclusionData());
    private final ChunkGraphNode[] nodes = new ChunkGraphNode[DirectionUtil.ALL_DIRECTIONS.length];
    private final int id;
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private int lastVisibleFrame = -1;
    private long visibilityData;
    private byte cullingState;

    public ChunkGraphNode(int chunkX, int chunkY, int chunkZ, int id) {
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.id = id;
        this.visibilityData = DEFAULT_VISIBILITY_DATA;
    }

    public ChunkGraphNode getConnectedNode(class_2350 dir) {
        return this.nodes[dir.ordinal()];
    }

    public void setLastVisibleFrame(int frame) {
        this.lastVisibleFrame = frame;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public void setAdjacentNode(class_2350 dir, ChunkGraphNode node) {
        this.nodes[dir.ordinal()] = node;
    }

    public void setOcclusionData(class_854 occlusionData) {
        this.visibilityData = ChunkGraphNode.calculateVisibilityData(occlusionData);
    }

    private static long calculateVisibilityData(class_854 occlusionData) {
        long visibilityData = 0L;
        for (class_2350 from : DirectionUtil.ALL_DIRECTIONS) {
            for (class_2350 to : DirectionUtil.ALL_DIRECTIONS) {
                if (occlusionData != null && !occlusionData.method_3695(from, to)) continue;
                visibilityData |= 1L << (from.ordinal() << 3) + to.ordinal();
            }
        }
        return visibilityData;
    }

    public boolean isVisibleThrough(class_2350 from, class_2350 to) {
        return (this.visibilityData & 1L << (from.ordinal() << 3) + to.ordinal()) != 0L;
    }

    public void setCullingState(byte parent, class_2350 dir) {
        this.cullingState = (byte)(parent | 1 << dir.ordinal());
    }

    public boolean canCull(class_2350 dir) {
        return (this.cullingState & 1 << dir.ordinal()) != 0;
    }

    public byte getCullingState() {
        return this.cullingState;
    }

    public void resetCullingState() {
        this.cullingState = 0;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCulledByFrustum(FrustumExtended frustum) {
        float z;
        float y;
        float x = this.getOriginX();
        return !frustum.fastAabbTest(x, y = (float)this.getOriginY(), z = (float)this.getOriginZ(), x + 16.0f, y + 16.0f, z + 16.0f);
    }

    public int getOriginX() {
        return this.chunkX << 4;
    }

    public int getOriginY() {
        return this.chunkY << 4;
    }

    public int getOriginZ() {
        return this.chunkZ << 4;
    }

    public double getSquaredDistance(class_2338 pos) {
        return this.getSquaredDistance((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    private double getCenterX() {
        return (double)this.getOriginX() + 8.0;
    }

    private double getCenterY() {
        return (double)this.getOriginY() + 8.0;
    }

    private double getCenterZ() {
        return (double)this.getOriginZ() + 8.0;
    }

    public double getSquaredDistance(double x, double y, double z) {
        double xDist = x - this.getCenterX();
        double yDist = y - this.getCenterY();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }
}

