/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.cull.graph;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkCuller;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphIterationQueue;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphNode;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_854;

public class ChunkGraphCuller
implements ChunkCuller {
    private final Long2ObjectMap<ChunkGraphNode> nodes = new Long2ObjectOpenHashMap();
    private final ChunkGraphIterationQueue visible = new ChunkGraphIterationQueue();
    private final class_1937 world;
    private final int renderDistance;
    private FrustumExtended frustum;
    private boolean useOcclusionCulling;
    private int activeFrame = 0;
    private int centerChunkX;
    private int centerChunkY;
    private int centerChunkZ;

    public ChunkGraphCuller(class_1937 world, int renderDistance) {
        this.world = world;
        this.renderDistance = renderDistance;
    }

    @Override
    public IntArrayList computeVisible(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.initSearch(camera, frustum, frame, spectator);
        ChunkGraphIterationQueue queue = this.visible;
        for (int i = 0; i < queue.size(); ++i) {
            ChunkGraphNode node = queue.getNode(i);
            class_2350 flow = queue.getDirection(i);
            for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
                ChunkGraphNode adj;
                if (this.isCulled(node, flow, dir) || (adj = node.getConnectedNode(dir)) == null || !this.isWithinRenderDistance(adj)) continue;
                this.bfsEnqueue(node, adj, dir.method_10153());
            }
        }
        return this.visible.getOrderedIdList();
    }

    private boolean isWithinRenderDistance(ChunkGraphNode adj) {
        int x = Math.abs(adj.getChunkX() - this.centerChunkX);
        int z = Math.abs(adj.getChunkZ() - this.centerChunkZ);
        return x <= this.renderDistance && z <= this.renderDistance;
    }

    private boolean isCulled(ChunkGraphNode node, class_2350 from, class_2350 to) {
        if (node.canCull(to)) {
            return true;
        }
        return this.useOcclusionCulling && from != null && !node.isVisibleThrough(from, to);
    }

    private void initSearch(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.activeFrame = frame;
        this.frustum = frustum;
        this.useOcclusionCulling = class_310.method_1551().field_1730;
        this.visible.clear();
        class_2338 origin = camera.method_19328();
        int chunkX = origin.method_10263() >> 4;
        int chunkY = origin.method_10264() >> 4;
        int chunkZ = origin.method_10260() >> 4;
        this.centerChunkX = chunkX;
        this.centerChunkY = chunkY;
        this.centerChunkZ = chunkZ;
        ChunkGraphNode rootNode = this.getNode(chunkX, chunkY, chunkZ);
        if (rootNode != null) {
            rootNode.resetCullingState();
            rootNode.setLastVisibleFrame(frame);
            if (spectator && this.world.method_8320(origin).method_26216((class_1922)this.world, origin)) {
                this.useOcclusionCulling = false;
            }
            this.visible.add(rootNode, null);
        } else {
            chunkY = class_3532.method_15340((int)(origin.method_10264() >> 4), (int)0, (int)15);
            ArrayList<ChunkGraphNode> bestNodes = new ArrayList<ChunkGraphNode>();
            for (int x2 = -this.renderDistance; x2 <= this.renderDistance; ++x2) {
                for (int z2 = -this.renderDistance; z2 <= this.renderDistance; ++z2) {
                    ChunkGraphNode node2 = this.getNode(chunkX + x2, chunkY, chunkZ + z2);
                    if (node2 == null || node2.isCulledByFrustum(frustum)) continue;
                    node2.resetCullingState();
                    node2.setLastVisibleFrame(frame);
                    bestNodes.add(node2);
                }
            }
            bestNodes.sort(Comparator.comparingDouble(node -> node.getSquaredDistance(origin)));
            for (ChunkGraphNode node3 : bestNodes) {
                this.visible.add(node3, null);
            }
        }
    }

    private void bfsEnqueue(ChunkGraphNode parent, ChunkGraphNode node, class_2350 flow) {
        if (node.getLastVisibleFrame() == this.activeFrame) {
            return;
        }
        if (node.isCulledByFrustum(this.frustum)) {
            return;
        }
        node.setLastVisibleFrame(this.activeFrame);
        node.setCullingState(parent.getCullingState(), flow);
        this.visible.add(node, flow);
    }

    private void connectNeighborNodes(ChunkGraphNode node) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkGraphNode adj = this.findAdjacentNode(node, dir);
            if (adj != null) {
                adj.setAdjacentNode(dir.method_10153(), node);
            }
            node.setAdjacentNode(dir, adj);
        }
    }

    private void disconnectNeighborNodes(ChunkGraphNode node) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkGraphNode adj = node.getConnectedNode(dir);
            if (adj != null) {
                adj.setAdjacentNode(dir.method_10153(), null);
            }
            node.setAdjacentNode(dir, null);
        }
    }

    private ChunkGraphNode findAdjacentNode(ChunkGraphNode node, class_2350 dir) {
        return this.getNode(node.getChunkX() + dir.method_10148(), node.getChunkY() + dir.method_10164(), node.getChunkZ() + dir.method_10165());
    }

    private ChunkGraphNode getNode(int x, int y, int z) {
        return (ChunkGraphNode)this.nodes.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    @Override
    public void onSectionStateChanged(int x, int y, int z, class_854 occlusionData) {
        ChunkGraphNode node = this.getNode(x, y, z);
        if (node != null) {
            node.setOcclusionData(occlusionData);
        }
    }

    @Override
    public void onSectionLoaded(int x, int y, int z, int id) {
        ChunkGraphNode node = new ChunkGraphNode(x, y, z, id);
        ChunkGraphNode prev = (ChunkGraphNode)this.nodes.put(class_4076.method_18685((int)x, (int)y, (int)z), (Object)node);
        if (prev != null) {
            this.disconnectNeighborNodes(prev);
        }
        this.connectNeighborNodes(node);
    }

    @Override
    public void onSectionUnloaded(int x, int y, int z) {
        ChunkGraphNode node = (ChunkGraphNode)this.nodes.remove(class_4076.method_18685((int)x, (int)y, (int)z));
        if (node != null) {
            this.disconnectNeighborNodes(node);
        }
    }

    @Override
    public boolean isSectionVisible(int x, int y, int z) {
        ChunkGraphNode render = this.getNode(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.activeFrame;
    }
}

