/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import java.lang.reflect.Array;
import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderColumn;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_4076;

public class ChunkRenderContainer<T extends ChunkGraphicsState> {
    private final SodiumWorldRenderer worldRenderer;
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private final T[] graphicsStates;
    private final ChunkRenderColumn<T> column;
    private ChunkRenderData data = ChunkRenderData.ABSENT;
    private CompletableFuture<Void> rebuildTask = null;
    private boolean needsRebuild;
    private boolean needsImportantRebuild;
    private boolean tickable;
    private int id;

    public ChunkRenderContainer(ChunkRenderBackend<T> backend, SodiumWorldRenderer worldRenderer, int chunkX, int chunkY, int chunkZ, ChunkRenderColumn<T> column) {
        this.worldRenderer = worldRenderer;
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.graphicsStates = (ChunkGraphicsState[])Array.newInstance(backend.getGraphicsStateType(), BlockRenderPass.COUNT);
        this.column = column;
    }

    public void cancelRebuildTask() {
        this.needsRebuild = false;
        this.needsImportantRebuild = false;
        if (this.rebuildTask != null) {
            this.rebuildTask.cancel(false);
            this.rebuildTask = null;
        }
    }

    public ChunkRenderData getData() {
        return this.data;
    }

    public boolean needsRebuild() {
        return this.needsRebuild;
    }

    public boolean needsImportantRebuild() {
        return this.needsImportantRebuild;
    }

    public void delete() {
        this.cancelRebuildTask();
        this.setData(ChunkRenderData.ABSENT);
        this.deleteGraphicsState();
    }

    private void deleteGraphicsState() {
        T[] states = this.graphicsStates;
        for (int i = 0; i < states.length; ++i) {
            T state = states[i];
            if (state == null) continue;
            ((ChunkGraphicsState)state).delete(RenderDevice.INSTANCE.createCommandList());
            states[i] = null;
        }
    }

    public void setData(ChunkRenderData info) {
        if (info == null) {
            throw new NullPointerException("Mesh information must not be null");
        }
        this.worldRenderer.onChunkRenderUpdated(this.chunkX, this.chunkY, this.chunkZ, this.data, info);
        this.data = info;
        this.tickable = !info.getAnimatedSprites().isEmpty();
    }

    public boolean scheduleRebuild(boolean important) {
        boolean changed = !this.needsRebuild || !this.needsImportantRebuild && important;
        this.needsImportantRebuild = important;
        this.needsRebuild = true;
        return changed;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public class_4076 getChunkPos() {
        return class_4076.method_18676((int)this.chunkX, (int)this.chunkY, (int)this.chunkZ);
    }

    public boolean isOutsideFrustum(FrustumExtended frustum) {
        float z;
        float y;
        float x = this.getOriginX();
        return !frustum.fastAabbTest(x, y = (float)this.getOriginY(), z = (float)this.getOriginZ(), x + 16.0f, y + 16.0f, z + 16.0f);
    }

    public void tick() {
        for (class_1058 sprite : this.data.getAnimatedSprites()) {
            SpriteUtil.markSpriteActive(sprite);
        }
    }

    public int getOriginX() {
        return this.chunkX << 4;
    }

    public int getOriginY() {
        return this.chunkY << 4;
    }

    public int getOriginZ() {
        return this.chunkZ << 4;
    }

    public int getRenderX() {
        return this.getOriginX() - 8;
    }

    public int getRenderY() {
        return this.getOriginY() - 8;
    }

    public int getRenderZ() {
        return this.getOriginZ() - 8;
    }

    public double getSquaredDistance(double x, double y, double z) {
        double xDist = x - this.getCenterX();
        double yDist = y - this.getCenterY();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    private double getCenterX() {
        return (double)this.getOriginX() + 8.0;
    }

    private double getCenterY() {
        return (double)this.getOriginY() + 8.0;
    }

    private double getCenterZ() {
        return (double)this.getOriginZ() + 8.0;
    }

    public class_2338 getRenderOrigin() {
        return new class_2338(this.getRenderX(), this.getRenderY(), this.getRenderZ());
    }

    public T[] getGraphicsStates() {
        return this.graphicsStates;
    }

    public void setGraphicsState(BlockRenderPass pass, T state) {
        this.graphicsStates[pass.ordinal()] = state;
    }

    public double getSquaredDistanceXZ(double x, double z) {
        double xDist = x - this.getCenterX();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + zDist * zDist;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public ChunkRenderBounds getBounds() {
        return this.data.getBounds();
    }

    public T getGraphicsState(BlockRenderPass pass) {
        return this.graphicsStates[pass.ordinal()];
    }

    public boolean isTickable() {
        return this.tickable;
    }

    public int getFacesWithData() {
        return this.data.getFacesWithData();
    }

    public boolean canRebuild() {
        return this.column.areNeighborsPresent();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }
}

