/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_2350;

public class ChunkRenderColumn<T extends ChunkGraphicsState> {
    private final ChunkRenderContainer<T>[] renders = new ChunkRenderContainer[16];
    private final ChunkRenderColumn<T>[] adjacent = new ChunkRenderColumn[6];
    private final int x;
    private final int z;

    public ChunkRenderColumn(int x, int z) {
        this.x = x;
        this.z = z;
        this.setAdjacentColumn(class_2350.field_11036, this);
        this.setAdjacentColumn(class_2350.field_11033, this);
    }

    public void setAdjacentColumn(class_2350 dir, ChunkRenderColumn<T> column) {
        this.adjacent[dir.ordinal()] = column;
    }

    public ChunkRenderColumn<T> getAdjacentColumn(class_2350 dir) {
        return this.adjacent[dir.ordinal()];
    }

    public void setRender(int y, ChunkRenderContainer<T> render) {
        this.renders[y] = render;
    }

    public ChunkRenderContainer<T> getRender(int y) {
        if (y < 0 || y >= this.renders.length) {
            return null;
        }
        return this.renders[y];
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean areNeighborsPresent() {
        for (class_2350 dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            class_2350 corner;
            ChunkRenderColumn<T> adj = this.adjacent[dir.ordinal()];
            if (adj == null) {
                return false;
            }
            if (dir == class_2350.field_11043) {
                corner = class_2350.field_11034;
            } else if (dir == class_2350.field_11035) {
                corner = class_2350.field_11039;
            } else if (dir == class_2350.field_11039) {
                corner = class_2350.field_11043;
            } else {
                if (dir != class_2350.field_11034) continue;
                corner = class_2350.field_11035;
            }
            if (adj.getAdjacentColumn(corner) != null) continue;
            return false;
        }
        return true;
    }
}

